<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemModifier StructType
 * @subpackage Structs
 */
class ItemModifier extends AbstractStructBase
{
    /**
     * The ItemModifierName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemModifierName;
    /**
     * The ItemModifierQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemModifierQuantity;
    /**
     * The ItemModifierPart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemModifierPart;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * Constructor method for ItemModifier
     * @uses ItemModifier::setItemModifierName()
     * @uses ItemModifier::setItemModifierQuantity()
     * @uses ItemModifier::setItemModifierPart()
     * @uses ItemModifier::setCode()
     * @param string $itemModifierName
     * @param string $itemModifierQuantity
     * @param string $itemModifierPart
     * @param string $code
     */
    public function __construct($itemModifierName = null, $itemModifierQuantity = null, $itemModifierPart = null, $code = null)
    {
        $this
            ->setItemModifierName($itemModifierName)
            ->setItemModifierQuantity($itemModifierQuantity)
            ->setItemModifierPart($itemModifierPart)
            ->setCode($code);
    }
    /**
     * Get ItemModifierName value
     * @return string|null
     */
    public function getItemModifierName()
    {
        return $this->ItemModifierName;
    }
    /**
     * Set ItemModifierName value
     * @param string $itemModifierName
     * @return \StructType\ItemModifier
     */
    public function setItemModifierName($itemModifierName = null)
    {
        // validation for constraint: string
        if (!is_null($itemModifierName) && !is_string($itemModifierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemModifierName)), __LINE__);
        }
        $this->ItemModifierName = $itemModifierName;
        return $this;
    }
    /**
     * Get ItemModifierQuantity value
     * @return string|null
     */
    public function getItemModifierQuantity()
    {
        return $this->ItemModifierQuantity;
    }
    /**
     * Set ItemModifierQuantity value
     * @param string $itemModifierQuantity
     * @return \StructType\ItemModifier
     */
    public function setItemModifierQuantity($itemModifierQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($itemModifierQuantity) && !is_string($itemModifierQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemModifierQuantity)), __LINE__);
        }
        $this->ItemModifierQuantity = $itemModifierQuantity;
        return $this;
    }
    /**
     * Get ItemModifierPart value
     * @return string|null
     */
    public function getItemModifierPart()
    {
        return $this->ItemModifierPart;
    }
    /**
     * Set ItemModifierPart value
     * @param string $itemModifierPart
     * @return \StructType\ItemModifier
     */
    public function setItemModifierPart($itemModifierPart = null)
    {
        // validation for constraint: string
        if (!is_null($itemModifierPart) && !is_string($itemModifierPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemModifierPart)), __LINE__);
        }
        $this->ItemModifierPart = $itemModifierPart;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ItemModifier
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemModifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
