<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HoursOfOperation StructType
 * @subpackage Structs
 */
class HoursOfOperation extends AbstractStructBase
{
    /**
     * The ServiceMethodHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ServiceMethodHours[]
     */
    public $ServiceMethodHours;
    /**
     * Constructor method for HoursOfOperation
     * @uses HoursOfOperation::setServiceMethodHours()
     * @param \StructType\ServiceMethodHours[] $serviceMethodHours
     */
    public function __construct(array $serviceMethodHours = array())
    {
        $this
            ->setServiceMethodHours($serviceMethodHours);
    }
    /**
     * Get ServiceMethodHours value
     * @return \StructType\ServiceMethodHours[]|null
     */
    public function getServiceMethodHours()
    {
        return $this->ServiceMethodHours;
    }
    /**
     * Set ServiceMethodHours value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceMethodHours[] $serviceMethodHours
     * @return \StructType\HoursOfOperation
     */
    public function setServiceMethodHours(array $serviceMethodHours = array())
    {
        foreach ($serviceMethodHours as $hoursOfOperationServiceMethodHoursItem) {
            // validation for constraint: itemType
            if (!$hoursOfOperationServiceMethodHoursItem instanceof \StructType\ServiceMethodHours) {
                throw new \InvalidArgumentException(sprintf('The ServiceMethodHours property can only contain items of \StructType\ServiceMethodHours, "%s" given', is_object($hoursOfOperationServiceMethodHoursItem) ? get_class($hoursOfOperationServiceMethodHoursItem) : gettype($hoursOfOperationServiceMethodHoursItem)), __LINE__);
            }
        }
        $this->ServiceMethodHours = $serviceMethodHours;
        return $this;
    }
    /**
     * Add item to ServiceMethodHours value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceMethodHours $item
     * @return \StructType\HoursOfOperation
     */
    public function addToServiceMethodHours(\StructType\ServiceMethodHours $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceMethodHours) {
            throw new \InvalidArgumentException(sprintf('The ServiceMethodHours property can only contain items of \StructType\ServiceMethodHours, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceMethodHours[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HoursOfOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
