<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Holidays StructType
 * @subpackage Structs
 */
class Holidays extends AbstractStructBase
{
    /**
     * The Holiday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \StructType\Holiday[]
     */
    public $Holiday;
    /**
     * Constructor method for Holidays
     * @uses Holidays::setHoliday()
     * @param \StructType\Holiday[] $holiday
     */
    public function __construct(array $holiday = array())
    {
        $this
            ->setHoliday($holiday);
    }
    /**
     * Get Holiday value
     * @return \StructType\Holiday[]|null
     */
    public function getHoliday()
    {
        return $this->Holiday;
    }
    /**
     * Set Holiday value
     * @throws \InvalidArgumentException
     * @param \StructType\Holiday[] $holiday
     * @return \StructType\Holidays
     */
    public function setHoliday(array $holiday = array())
    {
        foreach ($holiday as $holidaysHolidayItem) {
            // validation for constraint: itemType
            if (!$holidaysHolidayItem instanceof \StructType\Holiday) {
                throw new \InvalidArgumentException(sprintf('The Holiday property can only contain items of \StructType\Holiday, "%s" given', is_object($holidaysHolidayItem) ? get_class($holidaysHolidayItem) : gettype($holidaysHolidayItem)), __LINE__);
            }
        }
        $this->Holiday = $holiday;
        return $this;
    }
    /**
     * Add item to Holiday value
     * @throws \InvalidArgumentException
     * @param \StructType\Holiday $item
     * @return \StructType\Holidays
     */
    public function addToHoliday(\StructType\Holiday $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Holiday) {
            throw new \InvalidArgumentException(sprintf('The Holiday property can only contain items of \StructType\Holiday, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Holiday[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Holidays
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
