<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerTypeInfo StructType
 * @subpackage Structs
 */
class CustomerTypeInfo extends AbstractStructBase
{
    /**
     * The OrganizationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationName;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Department;
    /**
     * The OrganizationNameKana
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationNameKana;
    /**
     * The DepartmentKana
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartmentKana;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for CustomerTypeInfo
     * @uses CustomerTypeInfo::setOrganizationName()
     * @uses CustomerTypeInfo::setDepartment()
     * @uses CustomerTypeInfo::setOrganizationNameKana()
     * @uses CustomerTypeInfo::setDepartmentKana()
     * @uses CustomerTypeInfo::setType()
     * @param string $organizationName
     * @param string $department
     * @param string $organizationNameKana
     * @param string $departmentKana
     * @param string $type
     */
    public function __construct($organizationName = null, $department = null, $organizationNameKana = null, $departmentKana = null, $type = null)
    {
        $this
            ->setOrganizationName($organizationName)
            ->setDepartment($department)
            ->setOrganizationNameKana($organizationNameKana)
            ->setDepartmentKana($departmentKana)
            ->setType($type);
    }
    /**
     * Get OrganizationName value
     * @return string|null
     */
    public function getOrganizationName()
    {
        return $this->OrganizationName;
    }
    /**
     * Set OrganizationName value
     * @param string $organizationName
     * @return \StructType\CustomerTypeInfo
     */
    public function setOrganizationName($organizationName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationName) && !is_string($organizationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationName)), __LINE__);
        }
        $this->OrganizationName = $organizationName;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \StructType\CustomerTypeInfo
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Get OrganizationNameKana value
     * @return string|null
     */
    public function getOrganizationNameKana()
    {
        return $this->OrganizationNameKana;
    }
    /**
     * Set OrganizationNameKana value
     * @param string $organizationNameKana
     * @return \StructType\CustomerTypeInfo
     */
    public function setOrganizationNameKana($organizationNameKana = null)
    {
        // validation for constraint: string
        if (!is_null($organizationNameKana) && !is_string($organizationNameKana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationNameKana)), __LINE__);
        }
        $this->OrganizationNameKana = $organizationNameKana;
        return $this;
    }
    /**
     * Get DepartmentKana value
     * @return string|null
     */
    public function getDepartmentKana()
    {
        return $this->DepartmentKana;
    }
    /**
     * Set DepartmentKana value
     * @param string $departmentKana
     * @return \StructType\CustomerTypeInfo
     */
    public function setDepartmentKana($departmentKana = null)
    {
        // validation for constraint: string
        if (!is_null($departmentKana) && !is_string($departmentKana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departmentKana)), __LINE__);
        }
        $this->DepartmentKana = $departmentKana;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CustomerTypeInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerTypeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
