<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardPayment StructType
 * @subpackage Structs
 */
class CreditCardPayment extends AbstractStructBase
{
    /**
     * The CreditCardExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCardExpirationDate;
    /**
     * The CreditCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmount;
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardType;
    /**
     * The CreditCardToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardToken;
    /**
     * The CVV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CVV;
    /**
     * The BillingZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZipCode;
    /**
     * The CreditCardTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardTypeId;
    /**
     * The CardHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The WalletInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WalletInformation
     */
    public $WalletInformation;
    /**
     * The IsPayLater
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPayLater;
    /**
     * The TipAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipAmount;
    /**
     * Constructor method for CreditCardPayment
     * @uses CreditCardPayment::setCreditCardExpirationDate()
     * @uses CreditCardPayment::setCreditCardNumber()
     * @uses CreditCardPayment::setPaymentAmount()
     * @uses CreditCardPayment::setCreditCardType()
     * @uses CreditCardPayment::setCreditCardToken()
     * @uses CreditCardPayment::setCVV()
     * @uses CreditCardPayment::setBillingZipCode()
     * @uses CreditCardPayment::setCreditCardTypeId()
     * @uses CreditCardPayment::setCardHolderName()
     * @uses CreditCardPayment::setWalletInformation()
     * @uses CreditCardPayment::setIsPayLater()
     * @uses CreditCardPayment::setTipAmount()
     * @param string $creditCardExpirationDate
     * @param string $creditCardNumber
     * @param string $paymentAmount
     * @param string $creditCardType
     * @param string $creditCardToken
     * @param string $cVV
     * @param string $billingZipCode
     * @param string $creditCardTypeId
     * @param string $cardHolderName
     * @param \StructType\WalletInformation $walletInformation
     * @param bool $isPayLater
     * @param string $tipAmount
     */
    public function __construct($creditCardExpirationDate = null, $creditCardNumber = null, $paymentAmount = null, $creditCardType = null, $creditCardToken = null, $cVV = null, $billingZipCode = null, $creditCardTypeId = null, $cardHolderName = null, \StructType\WalletInformation $walletInformation = null, $isPayLater = null, $tipAmount = null)
    {
        $this
            ->setCreditCardExpirationDate($creditCardExpirationDate)
            ->setCreditCardNumber($creditCardNumber)
            ->setPaymentAmount($paymentAmount)
            ->setCreditCardType($creditCardType)
            ->setCreditCardToken($creditCardToken)
            ->setCVV($cVV)
            ->setBillingZipCode($billingZipCode)
            ->setCreditCardTypeId($creditCardTypeId)
            ->setCardHolderName($cardHolderName)
            ->setWalletInformation($walletInformation)
            ->setIsPayLater($isPayLater)
            ->setTipAmount($tipAmount);
    }
    /**
     * Get CreditCardExpirationDate value
     * @return string
     */
    public function getCreditCardExpirationDate()
    {
        return $this->CreditCardExpirationDate;
    }
    /**
     * Set CreditCardExpirationDate value
     * @param string $creditCardExpirationDate
     * @return \StructType\CreditCardPayment
     */
    public function setCreditCardExpirationDate($creditCardExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardExpirationDate) && !is_string($creditCardExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardExpirationDate)), __LINE__);
        }
        $this->CreditCardExpirationDate = $creditCardExpirationDate;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\CreditCardPayment
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return string|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param string $paymentAmount
     * @return \StructType\CreditCardPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmount) && !is_string($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get CreditCardType value
     * @return string|null
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @param string $creditCardType
     * @return \StructType\CreditCardPayment
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardType) && !is_string($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardType)), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get CreditCardToken value
     * @return string|null
     */
    public function getCreditCardToken()
    {
        return $this->CreditCardToken;
    }
    /**
     * Set CreditCardToken value
     * @param string $creditCardToken
     * @return \StructType\CreditCardPayment
     */
    public function setCreditCardToken($creditCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardToken) && !is_string($creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardToken)), __LINE__);
        }
        $this->CreditCardToken = $creditCardToken;
        return $this;
    }
    /**
     * Get CVV value
     * @return string|null
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \StructType\CreditCardPayment
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cVV)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get BillingZipCode value
     * @return string|null
     */
    public function getBillingZipCode()
    {
        return $this->BillingZipCode;
    }
    /**
     * Set BillingZipCode value
     * @param string $billingZipCode
     * @return \StructType\CreditCardPayment
     */
    public function setBillingZipCode($billingZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingZipCode) && !is_string($billingZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZipCode)), __LINE__);
        }
        $this->BillingZipCode = $billingZipCode;
        return $this;
    }
    /**
     * Get CreditCardTypeId value
     * @return string|null
     */
    public function getCreditCardTypeId()
    {
        return $this->CreditCardTypeId;
    }
    /**
     * Set CreditCardTypeId value
     * @param string $creditCardTypeId
     * @return \StructType\CreditCardPayment
     */
    public function setCreditCardTypeId($creditCardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardTypeId) && !is_string($creditCardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardTypeId)), __LINE__);
        }
        $this->CreditCardTypeId = $creditCardTypeId;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \StructType\CreditCardPayment
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolderName)), __LINE__);
        }
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get WalletInformation value
     * @return \StructType\WalletInformation|null
     */
    public function getWalletInformation()
    {
        return $this->WalletInformation;
    }
    /**
     * Set WalletInformation value
     * @param \StructType\WalletInformation $walletInformation
     * @return \StructType\CreditCardPayment
     */
    public function setWalletInformation(\StructType\WalletInformation $walletInformation = null)
    {
        $this->WalletInformation = $walletInformation;
        return $this;
    }
    /**
     * Get IsPayLater value
     * @return bool|null
     */
    public function getIsPayLater()
    {
        return $this->IsPayLater;
    }
    /**
     * Set IsPayLater value
     * @param bool $isPayLater
     * @return \StructType\CreditCardPayment
     */
    public function setIsPayLater($isPayLater = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPayLater) && !is_bool($isPayLater)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPayLater)), __LINE__);
        }
        $this->IsPayLater = $isPayLater;
        return $this;
    }
    /**
     * Get TipAmount value
     * @return string|null
     */
    public function getTipAmount()
    {
        return $this->TipAmount;
    }
    /**
     * Set TipAmount value
     * @param string $tipAmount
     * @return \StructType\CreditCardPayment
     */
    public function setTipAmount($tipAmount = null)
    {
        // validation for constraint: string
        if (!is_null($tipAmount) && !is_string($tipAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipAmount)), __LINE__);
        }
        $this->TipAmount = $tipAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
