<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponProduct StructType
 * @subpackage Structs
 */
class CouponProduct extends AbstractStructBase
{
    /**
     * The TargetProduct
     * @var string
     */
    public $TargetProduct;
    /**
     * The TargetProductCode
     * @var string
     */
    public $TargetProductCode;
    /**
     * The RequiredQuantity
     * @var string
     */
    public $RequiredQuantity;
    /**
     * The MaximumQuantityAllowed
     * @var string
     */
    public $MaximumQuantityAllowed;
    /**
     * The RegularPrice
     * @var string
     */
    public $RegularPrice;
    /**
     * The MinimumPrice
     * @var string
     */
    public $MinimumPrice;
    /**
     * The MaximumDiscount
     * @var string
     */
    public $MaximumDiscount;
    /**
     * The IncludedOptionQuantity
     * @var string
     */
    public $IncludedOptionQuantity;
    /**
     * The DefaultCategoryCode
     * @var string
     */
    public $DefaultCategoryCode;
    /**
     * The DefaultFlavorCode
     * @var string
     */
    public $DefaultFlavorCode;
    /**
     * The DefaultSizeCode
     * @var string
     */
    public $DefaultSizeCode;
    /**
     * The DefaultOsgCode
     * @var string
     */
    public $DefaultOsgCode;
    /**
     * The AcceptableProducts
     * @var \StructType\AcceptableProduct
     */
    public $AcceptableProducts;
    /**
     * The ValidProductFilters
     * @var \StructType\ValidProductFilter
     */
    public $ValidProductFilters;
    /**
     * Constructor method for CouponProduct
     * @uses CouponProduct::setTargetProduct()
     * @uses CouponProduct::setTargetProductCode()
     * @uses CouponProduct::setRequiredQuantity()
     * @uses CouponProduct::setMaximumQuantityAllowed()
     * @uses CouponProduct::setRegularPrice()
     * @uses CouponProduct::setMinimumPrice()
     * @uses CouponProduct::setMaximumDiscount()
     * @uses CouponProduct::setIncludedOptionQuantity()
     * @uses CouponProduct::setDefaultCategoryCode()
     * @uses CouponProduct::setDefaultFlavorCode()
     * @uses CouponProduct::setDefaultSizeCode()
     * @uses CouponProduct::setDefaultOsgCode()
     * @uses CouponProduct::setAcceptableProducts()
     * @uses CouponProduct::setValidProductFilters()
     * @param string $targetProduct
     * @param string $targetProductCode
     * @param string $requiredQuantity
     * @param string $maximumQuantityAllowed
     * @param string $regularPrice
     * @param string $minimumPrice
     * @param string $maximumDiscount
     * @param string $includedOptionQuantity
     * @param string $defaultCategoryCode
     * @param string $defaultFlavorCode
     * @param string $defaultSizeCode
     * @param string $defaultOsgCode
     * @param \StructType\AcceptableProduct $acceptableProducts
     * @param \StructType\ValidProductFilter $validProductFilters
     */
    public function __construct($targetProduct = null, $targetProductCode = null, $requiredQuantity = null, $maximumQuantityAllowed = null, $regularPrice = null, $minimumPrice = null, $maximumDiscount = null, $includedOptionQuantity = null, $defaultCategoryCode = null, $defaultFlavorCode = null, $defaultSizeCode = null, $defaultOsgCode = null, \StructType\AcceptableProduct $acceptableProducts = null, \StructType\ValidProductFilter $validProductFilters = null)
    {
        $this
            ->setTargetProduct($targetProduct)
            ->setTargetProductCode($targetProductCode)
            ->setRequiredQuantity($requiredQuantity)
            ->setMaximumQuantityAllowed($maximumQuantityAllowed)
            ->setRegularPrice($regularPrice)
            ->setMinimumPrice($minimumPrice)
            ->setMaximumDiscount($maximumDiscount)
            ->setIncludedOptionQuantity($includedOptionQuantity)
            ->setDefaultCategoryCode($defaultCategoryCode)
            ->setDefaultFlavorCode($defaultFlavorCode)
            ->setDefaultSizeCode($defaultSizeCode)
            ->setDefaultOsgCode($defaultOsgCode)
            ->setAcceptableProducts($acceptableProducts)
            ->setValidProductFilters($validProductFilters);
    }
    /**
     * Get TargetProduct value
     * @return string|null
     */
    public function getTargetProduct()
    {
        return $this->TargetProduct;
    }
    /**
     * Set TargetProduct value
     * @param string $targetProduct
     * @return \StructType\CouponProduct
     */
    public function setTargetProduct($targetProduct = null)
    {
        // validation for constraint: string
        if (!is_null($targetProduct) && !is_string($targetProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetProduct)), __LINE__);
        }
        $this->TargetProduct = $targetProduct;
        return $this;
    }
    /**
     * Get TargetProductCode value
     * @return string|null
     */
    public function getTargetProductCode()
    {
        return $this->TargetProductCode;
    }
    /**
     * Set TargetProductCode value
     * @param string $targetProductCode
     * @return \StructType\CouponProduct
     */
    public function setTargetProductCode($targetProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($targetProductCode) && !is_string($targetProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetProductCode)), __LINE__);
        }
        $this->TargetProductCode = $targetProductCode;
        return $this;
    }
    /**
     * Get RequiredQuantity value
     * @return string|null
     */
    public function getRequiredQuantity()
    {
        return $this->RequiredQuantity;
    }
    /**
     * Set RequiredQuantity value
     * @param string $requiredQuantity
     * @return \StructType\CouponProduct
     */
    public function setRequiredQuantity($requiredQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($requiredQuantity) && !is_string($requiredQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredQuantity)), __LINE__);
        }
        $this->RequiredQuantity = $requiredQuantity;
        return $this;
    }
    /**
     * Get MaximumQuantityAllowed value
     * @return string|null
     */
    public function getMaximumQuantityAllowed()
    {
        return $this->MaximumQuantityAllowed;
    }
    /**
     * Set MaximumQuantityAllowed value
     * @param string $maximumQuantityAllowed
     * @return \StructType\CouponProduct
     */
    public function setMaximumQuantityAllowed($maximumQuantityAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($maximumQuantityAllowed) && !is_string($maximumQuantityAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumQuantityAllowed)), __LINE__);
        }
        $this->MaximumQuantityAllowed = $maximumQuantityAllowed;
        return $this;
    }
    /**
     * Get RegularPrice value
     * @return string|null
     */
    public function getRegularPrice()
    {
        return $this->RegularPrice;
    }
    /**
     * Set RegularPrice value
     * @param string $regularPrice
     * @return \StructType\CouponProduct
     */
    public function setRegularPrice($regularPrice = null)
    {
        // validation for constraint: string
        if (!is_null($regularPrice) && !is_string($regularPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regularPrice)), __LINE__);
        }
        $this->RegularPrice = $regularPrice;
        return $this;
    }
    /**
     * Get MinimumPrice value
     * @return string|null
     */
    public function getMinimumPrice()
    {
        return $this->MinimumPrice;
    }
    /**
     * Set MinimumPrice value
     * @param string $minimumPrice
     * @return \StructType\CouponProduct
     */
    public function setMinimumPrice($minimumPrice = null)
    {
        // validation for constraint: string
        if (!is_null($minimumPrice) && !is_string($minimumPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumPrice)), __LINE__);
        }
        $this->MinimumPrice = $minimumPrice;
        return $this;
    }
    /**
     * Get MaximumDiscount value
     * @return string|null
     */
    public function getMaximumDiscount()
    {
        return $this->MaximumDiscount;
    }
    /**
     * Set MaximumDiscount value
     * @param string $maximumDiscount
     * @return \StructType\CouponProduct
     */
    public function setMaximumDiscount($maximumDiscount = null)
    {
        // validation for constraint: string
        if (!is_null($maximumDiscount) && !is_string($maximumDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumDiscount)), __LINE__);
        }
        $this->MaximumDiscount = $maximumDiscount;
        return $this;
    }
    /**
     * Get IncludedOptionQuantity value
     * @return string|null
     */
    public function getIncludedOptionQuantity()
    {
        return $this->IncludedOptionQuantity;
    }
    /**
     * Set IncludedOptionQuantity value
     * @param string $includedOptionQuantity
     * @return \StructType\CouponProduct
     */
    public function setIncludedOptionQuantity($includedOptionQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($includedOptionQuantity) && !is_string($includedOptionQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includedOptionQuantity)), __LINE__);
        }
        $this->IncludedOptionQuantity = $includedOptionQuantity;
        return $this;
    }
    /**
     * Get DefaultCategoryCode value
     * @return string|null
     */
    public function getDefaultCategoryCode()
    {
        return $this->DefaultCategoryCode;
    }
    /**
     * Set DefaultCategoryCode value
     * @param string $defaultCategoryCode
     * @return \StructType\CouponProduct
     */
    public function setDefaultCategoryCode($defaultCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCategoryCode) && !is_string($defaultCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultCategoryCode)), __LINE__);
        }
        $this->DefaultCategoryCode = $defaultCategoryCode;
        return $this;
    }
    /**
     * Get DefaultFlavorCode value
     * @return string|null
     */
    public function getDefaultFlavorCode()
    {
        return $this->DefaultFlavorCode;
    }
    /**
     * Set DefaultFlavorCode value
     * @param string $defaultFlavorCode
     * @return \StructType\CouponProduct
     */
    public function setDefaultFlavorCode($defaultFlavorCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultFlavorCode) && !is_string($defaultFlavorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultFlavorCode)), __LINE__);
        }
        $this->DefaultFlavorCode = $defaultFlavorCode;
        return $this;
    }
    /**
     * Get DefaultSizeCode value
     * @return string|null
     */
    public function getDefaultSizeCode()
    {
        return $this->DefaultSizeCode;
    }
    /**
     * Set DefaultSizeCode value
     * @param string $defaultSizeCode
     * @return \StructType\CouponProduct
     */
    public function setDefaultSizeCode($defaultSizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSizeCode) && !is_string($defaultSizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultSizeCode)), __LINE__);
        }
        $this->DefaultSizeCode = $defaultSizeCode;
        return $this;
    }
    /**
     * Get DefaultOsgCode value
     * @return string|null
     */
    public function getDefaultOsgCode()
    {
        return $this->DefaultOsgCode;
    }
    /**
     * Set DefaultOsgCode value
     * @param string $defaultOsgCode
     * @return \StructType\CouponProduct
     */
    public function setDefaultOsgCode($defaultOsgCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultOsgCode) && !is_string($defaultOsgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultOsgCode)), __LINE__);
        }
        $this->DefaultOsgCode = $defaultOsgCode;
        return $this;
    }
    /**
     * Get AcceptableProducts value
     * @return \StructType\AcceptableProduct|null
     */
    public function getAcceptableProducts()
    {
        return $this->AcceptableProducts;
    }
    /**
     * Set AcceptableProducts value
     * @param \StructType\AcceptableProduct $acceptableProducts
     * @return \StructType\CouponProduct
     */
    public function setAcceptableProducts(\StructType\AcceptableProduct $acceptableProducts = null)
    {
        $this->AcceptableProducts = $acceptableProducts;
        return $this;
    }
    /**
     * Get ValidProductFilters value
     * @return \StructType\ValidProductFilter|null
     */
    public function getValidProductFilters()
    {
        return $this->ValidProductFilters;
    }
    /**
     * Set ValidProductFilters value
     * @param \StructType\ValidProductFilter $validProductFilters
     * @return \StructType\CouponProduct
     */
    public function setValidProductFilters(\StructType\ValidProductFilter $validProductFilters = null)
    {
        $this->ValidProductFilters = $validProductFilters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CouponProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
