<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePaymentTypes StructType
 * @subpackage Structs
 */
class AcceptablePaymentTypes extends AbstractStructBase
{
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 1
     * @var string[]
     */
    public $PaymentType;
    /**
     * The OLOIsTipAllowed
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $OLOIsTipAllowed;
    /**
     * Constructor method for AcceptablePaymentTypes
     * @uses AcceptablePaymentTypes::setPaymentType()
     * @uses AcceptablePaymentTypes::setOLOIsTipAllowed()
     * @param string[] $paymentType
     * @param string $oLOIsTipAllowed
     */
    public function __construct(array $paymentType = array(), $oLOIsTipAllowed = 'No')
    {
        $this
            ->setPaymentType($paymentType)
            ->setOLOIsTipAllowed($oLOIsTipAllowed);
    }
    /**
     * Get PaymentType value
     * @return string[]
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @throws \InvalidArgumentException
     * @param string[] $paymentType
     * @return \StructType\AcceptablePaymentTypes
     */
    public function setPaymentType(array $paymentType = array())
    {
        foreach ($paymentType as $acceptablePaymentTypesPaymentTypeItem) {
            // validation for constraint: itemType
            if (!is_string($acceptablePaymentTypesPaymentTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The PaymentType property can only contain items of string, "%s" given', is_object($acceptablePaymentTypesPaymentTypeItem) ? get_class($acceptablePaymentTypesPaymentTypeItem) : gettype($acceptablePaymentTypesPaymentTypeItem)), __LINE__);
            }
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Add item to PaymentType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AcceptablePaymentTypes
     */
    public function addToPaymentType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaymentType property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentType[] = $item;
        return $this;
    }
    /**
     * Get OLOIsTipAllowed value
     * @return string|null
     */
    public function getOLOIsTipAllowed()
    {
        return $this->OLOIsTipAllowed;
    }
    /**
     * Set OLOIsTipAllowed value
     * @param string $oLOIsTipAllowed
     * @return \StructType\AcceptablePaymentTypes
     */
    public function setOLOIsTipAllowed($oLOIsTipAllowed = 'No')
    {
        // validation for constraint: string
        if (!is_null($oLOIsTipAllowed) && !is_string($oLOIsTipAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oLOIsTipAllowed)), __LINE__);
        }
        $this->OLOIsTipAllowed = $oLOIsTipAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptablePaymentTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
