<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Authorization' => '\\StructType\\Authorization',
            'Notification' => '\\StructType\\Notification',
            'Order' => '\\StructType\\Order',
            'OrderSource' => '\\StructType\\OrderSource',
            'Customer' => '\\StructType\\Customer',
            'CustomerAddress' => '\\StructType\\CustomerAddress',
            'Name' => '\\StructType\\Name',
            'CustomerTypeInfo' => '\\StructType\\CustomerTypeInfo',
            'OrderItems' => '\\StructType\\OrderItems',
            'OrderItem' => '\\StructType\\OrderItem',
            'ProductCodes' => '\\StructType\\ProductCodes',
            'ProductCode' => '\\StructType\\ProductCode',
            'ItemModifiers' => '\\StructType\\ItemModifiers',
            'ItemModifier' => '\\StructType\\ItemModifier',
            'Payment' => '\\StructType\\Payment',
            'CashPayment' => '\\StructType\\CashPayment',
            'CheckPayment' => '\\StructType\\CheckPayment',
            'CreditCardPayment' => '\\StructType\\CreditCardPayment',
            'WalletInformation' => '\\StructType\\WalletInformation',
            'GiftCardPayment' => '\\StructType\\GiftCardPayment',
            'PointsPayment' => '\\StructType\\PointsPayment',
            'OrderReply' => '\\StructType\\OrderReply',
            'OrderAmounts' => '\\StructType\\OrderAmounts',
            'OrderTimings' => '\\StructType\\OrderTimings',
            'OrderStatuses' => '\\StructType\\OrderStatuses',
            'StoreInformation' => '\\StructType\\StoreInformation',
            'StoreServiceMethods' => '\\StructType\\StoreServiceMethods',
            'StoreServiceMethod' => '\\StructType\\StoreServiceMethod',
            'Address' => '\\StructType\\Address',
            'StoreSchedule' => '\\StructType\\StoreSchedule',
            'Holidays' => '\\StructType\\Holidays',
            'Holiday' => '\\StructType\\Holiday',
            'HoursOfOperation' => '\\StructType\\HoursOfOperation',
            'ServiceMethodHours' => '\\StructType\\ServiceMethodHours',
            'Day' => '\\StructType\\Day',
            'AcceptablePaymentTypes' => '\\StructType\\AcceptablePaymentTypes',
            'StoreService' => '\\StructType\\StoreService',
            'CancelOrderReasons' => '\\StructType\\CancelOrderReasons',
            'TaxStructure' => '\\StructType\\TaxStructure',
            'TaxRates' => '\\StructType\\TaxRates',
            'Tax' => '\\StructType\\Tax',
            'AcceptableCardTypeIDs' => '\\StructType\\AcceptableCardTypeIDs',
            'CardType' => '\\StructType\\CardType',
            'AcceptableCardTypes' => '\\StructType\\AcceptableCardTypes',
            'AcceptableCardType' => '\\StructType\\AcceptableCardType',
            'OtherCardSettings' => '\\StructType\\OtherCardSettings',
            'StoreProducts' => '\\StructType\\StoreProducts',
            'StoreCustomers' => '\\StructType\\StoreCustomers',
            'Coupons' => '\\StructType\\Coupons',
            'Coupon' => '\\StructType\\Coupon',
            'OrderInfoCollection' => '\\StructType\\OrderInfoCollection',
            'OrderInfo' => '\\StructType\\OrderInfo',
            'OrderSources' => '\\StructType\\OrderSources',
            'Source' => '\\StructType\\Source',
            'ServiceMethods' => '\\StructType\\ServiceMethods',
            'CouponProducts' => '\\StructType\\CouponProducts',
            'StoreCouponGroups' => '\\StructType\\StoreCouponGroups',
            'CouponProduct' => '\\StructType\\CouponProduct',
            'AcceptableProduct' => '\\StructType\\AcceptableProduct',
            'ValidProductFilter' => '\\StructType\\ValidProductFilter',
            'StoreCoupons' => '\\StructType\\StoreCoupons',
            'CouponGroups' => '\\StructType\\CouponGroups',
            'CouponGroup' => '\\StructType\\CouponGroup',
            'StoreStreets' => '\\StructType\\StoreStreets',
            'StatusReply' => '\\StructType\\StatusReply',
            'Languages' => '\\StructType\\Languages',
            'Language' => '\\StructType\\Language',
        );
    }
}
