<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webServiceResult StructType
 * @subpackage Structs
 */
class WebServiceResult extends AbstractStructBase
{
    /**
     * The codigoTransaccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoTransaccion;
    /**
     * The errores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebServiceError[]
     */
    public $errores;
    /**
     * The resultado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $resultado;
    /**
     * Constructor method for webServiceResult
     * @uses WebServiceResult::setCodigoTransaccion()
     * @uses WebServiceResult::setErrores()
     * @uses WebServiceResult::setResultado()
     * @param string $codigoTransaccion
     * @param \StructType\WebServiceError[] $errores
     * @param bool $resultado
     */
    public function __construct($codigoTransaccion = null, array $errores = array(), $resultado = null)
    {
        $this
            ->setCodigoTransaccion($codigoTransaccion)
            ->setErrores($errores)
            ->setResultado($resultado);
    }
    /**
     * Get codigoTransaccion value
     * @return string|null
     */
    public function getCodigoTransaccion()
    {
        return $this->codigoTransaccion;
    }
    /**
     * Set codigoTransaccion value
     * @param string $codigoTransaccion
     * @return \StructType\WebServiceResult
     */
    public function setCodigoTransaccion($codigoTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($codigoTransaccion) && !is_string($codigoTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoTransaccion)), __LINE__);
        }
        $this->codigoTransaccion = $codigoTransaccion;
        return $this;
    }
    /**
     * Get errores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebServiceError[]|null
     */
    public function getErrores()
    {
        return isset($this->errores) ? $this->errores : null;
    }
    /**
     * Set errores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceError[] $errores
     * @return \StructType\WebServiceResult
     */
    public function setErrores(array $errores = array())
    {
        foreach ($errores as $webServiceResultErroresItem) {
            // validation for constraint: itemType
            if (!$webServiceResultErroresItem instanceof \StructType\WebServiceError) {
                throw new \InvalidArgumentException(sprintf('The errores property can only contain items of \StructType\WebServiceError, "%s" given', is_object($webServiceResultErroresItem) ? get_class($webServiceResultErroresItem) : gettype($webServiceResultErroresItem)), __LINE__);
            }
        }
        if (is_null($errores) || (is_array($errores) && empty($errores))) {
            unset($this->errores);
        } else {
            $this->errores = $errores;
        }
        return $this;
    }
    /**
     * Add item to errores value
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceError $item
     * @return \StructType\WebServiceResult
     */
    public function addToErrores(\StructType\WebServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebServiceError) {
            throw new \InvalidArgumentException(sprintf('The errores property can only contain items of \StructType\WebServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errores[] = $item;
        return $this;
    }
    /**
     * Get resultado value
     * @return bool|null
     */
    public function getResultado()
    {
        return $this->resultado;
    }
    /**
     * Set resultado value
     * @param bool $resultado
     * @return \StructType\WebServiceResult
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultado) && !is_bool($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($resultado)), __LINE__);
        }
        $this->resultado = $resultado;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebServiceResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
