<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sustanciaPlainList StructType
 * @subpackage Structs
 */
class SustanciaPlainList extends AbstractStructBase
{
    /**
     * The sustancia
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SustanciaPlain[]
     */
    public $sustancia;
    /**
     * Constructor method for sustanciaPlainList
     * @uses SustanciaPlainList::setSustancia()
     * @param \StructType\SustanciaPlain[] $sustancia
     */
    public function __construct(array $sustancia = array())
    {
        $this
            ->setSustancia($sustancia);
    }
    /**
     * Get sustancia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SustanciaPlain[]|null
     */
    public function getSustancia()
    {
        return isset($this->sustancia) ? $this->sustancia : null;
    }
    /**
     * Set sustancia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SustanciaPlain[] $sustancia
     * @return \StructType\SustanciaPlainList
     */
    public function setSustancia(array $sustancia = array())
    {
        foreach ($sustancia as $sustanciaPlainListSustanciaItem) {
            // validation for constraint: itemType
            if (!$sustanciaPlainListSustanciaItem instanceof \StructType\SustanciaPlain) {
                throw new \InvalidArgumentException(sprintf('The sustancia property can only contain items of \StructType\SustanciaPlain, "%s" given', is_object($sustanciaPlainListSustanciaItem) ? get_class($sustanciaPlainListSustanciaItem) : gettype($sustanciaPlainListSustanciaItem)), __LINE__);
            }
        }
        if (is_null($sustancia) || (is_array($sustancia) && empty($sustancia))) {
            unset($this->sustancia);
        } else {
            $this->sustancia = $sustancia;
        }
        return $this;
    }
    /**
     * Add item to sustancia value
     * @throws \InvalidArgumentException
     * @param \StructType\SustanciaPlain $item
     * @return \StructType\SustanciaPlainList
     */
    public function addToSustancia(\StructType\SustanciaPlain $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SustanciaPlain) {
            throw new \InvalidArgumentException(sprintf('The sustancia property can only contain items of \StructType\SustanciaPlain, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sustancia[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SustanciaPlainList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
