<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for operadorResult StructType
 * @subpackage Structs
 */
class OperadorResult extends AbstractStructBase
{
    /**
     * The cantPaginas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cantPaginas;
    /**
     * The errores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $errores;
    /**
     * The hayError
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hayError;
    /**
     * The operadores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Operador[]
     */
    public $operadores;
    /**
     * Constructor method for operadorResult
     * @uses OperadorResult::setCantPaginas()
     * @uses OperadorResult::setErrores()
     * @uses OperadorResult::setHayError()
     * @uses OperadorResult::setOperadores()
     * @param int $cantPaginas
     * @param string[] $errores
     * @param bool $hayError
     * @param \StructType\Operador[] $operadores
     */
    public function __construct($cantPaginas = null, array $errores = array(), $hayError = null, array $operadores = array())
    {
        $this
            ->setCantPaginas($cantPaginas)
            ->setErrores($errores)
            ->setHayError($hayError)
            ->setOperadores($operadores);
    }
    /**
     * Get cantPaginas value
     * @return int|null
     */
    public function getCantPaginas()
    {
        return $this->cantPaginas;
    }
    /**
     * Set cantPaginas value
     * @param int $cantPaginas
     * @return \StructType\OperadorResult
     */
    public function setCantPaginas($cantPaginas = null)
    {
        // validation for constraint: int
        if (!is_null($cantPaginas) && !is_numeric($cantPaginas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cantPaginas)), __LINE__);
        }
        $this->cantPaginas = $cantPaginas;
        return $this;
    }
    /**
     * Get errores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getErrores()
    {
        return isset($this->errores) ? $this->errores : null;
    }
    /**
     * Set errores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $errores
     * @return \StructType\OperadorResult
     */
    public function setErrores(array $errores = array())
    {
        foreach ($errores as $operadorResultErroresItem) {
            // validation for constraint: itemType
            if (!is_string($operadorResultErroresItem)) {
                throw new \InvalidArgumentException(sprintf('The errores property can only contain items of string, "%s" given', is_object($operadorResultErroresItem) ? get_class($operadorResultErroresItem) : gettype($operadorResultErroresItem)), __LINE__);
            }
        }
        if (is_null($errores) || (is_array($errores) && empty($errores))) {
            unset($this->errores);
        } else {
            $this->errores = $errores;
        }
        return $this;
    }
    /**
     * Add item to errores value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OperadorResult
     */
    public function addToErrores($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The errores property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errores[] = $item;
        return $this;
    }
    /**
     * Get hayError value
     * @return bool|null
     */
    public function getHayError()
    {
        return $this->hayError;
    }
    /**
     * Set hayError value
     * @param bool $hayError
     * @return \StructType\OperadorResult
     */
    public function setHayError($hayError = null)
    {
        // validation for constraint: boolean
        if (!is_null($hayError) && !is_bool($hayError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hayError)), __LINE__);
        }
        $this->hayError = $hayError;
        return $this;
    }
    /**
     * Get operadores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Operador[]|null
     */
    public function getOperadores()
    {
        return isset($this->operadores) ? $this->operadores : null;
    }
    /**
     * Set operadores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Operador[] $operadores
     * @return \StructType\OperadorResult
     */
    public function setOperadores(array $operadores = array())
    {
        foreach ($operadores as $operadorResultOperadoresItem) {
            // validation for constraint: itemType
            if (!$operadorResultOperadoresItem instanceof \StructType\Operador) {
                throw new \InvalidArgumentException(sprintf('The operadores property can only contain items of \StructType\Operador, "%s" given', is_object($operadorResultOperadoresItem) ? get_class($operadorResultOperadoresItem) : gettype($operadorResultOperadoresItem)), __LINE__);
            }
        }
        if (is_null($operadores) || (is_array($operadores) && empty($operadores))) {
            unset($this->operadores);
        } else {
            $this->operadores = $operadores;
        }
        return $this;
    }
    /**
     * Add item to operadores value
     * @throws \InvalidArgumentException
     * @param \StructType\Operador $item
     * @return \StructType\OperadorResult
     */
    public function addToOperadores(\StructType\Operador $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Operador) {
            throw new \InvalidArgumentException(sprintf('The operadores property can only contain items of \StructType\Operador, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->operadores[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperadorResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
