<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://trazabilidad.pami.org.ar:59050/trazamed.WebServiceSDRN?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://trazabilidad.pami.org.ar:59050/trazamed.WebServiceSDRN?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for saveTransacciones operation/method
 */
if ($save->saveTransacciones(new \StructType\SaveTransacciones()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getTransaccionesWs operation/method
 */
if ($get->getTransaccionesWs(new \StructType\GetTransaccionesWs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCatalogoElectronicoByGTIN operation/method
 */
if ($get->getCatalogoElectronicoByGTIN(new \StructType\GetCatalogoElectronicoByGTIN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOperadores operation/method
 */
if ($get->getOperadores(new \StructType\GetOperadores()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCatalogoElectronicoByGLN operation/method
 */
if ($get->getCatalogoElectronicoByGLN(new \StructType\GetCatalogoElectronicoByGLN()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendCancelaTransac operation/method
 */
if ($send->sendCancelaTransac(new \StructType\SendCancelaTransac()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
