<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transaccionesWsResult StructType
 * @subpackage Structs
 */
class TransaccionesWsResult extends AbstractStructBase
{
    /**
     * The cantPaginas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cantPaginas;
    /**
     * The errores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebServiceError[]
     */
    public $errores;
    /**
     * The hayError
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hayError;
    /**
     * The transacciones
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransaccionSdrnPlain[]
     */
    public $transacciones;
    /**
     * Constructor method for transaccionesWsResult
     * @uses TransaccionesWsResult::setCantPaginas()
     * @uses TransaccionesWsResult::setErrores()
     * @uses TransaccionesWsResult::setHayError()
     * @uses TransaccionesWsResult::setTransacciones()
     * @param int $cantPaginas
     * @param \StructType\WebServiceError[] $errores
     * @param bool $hayError
     * @param \StructType\TransaccionSdrnPlain[] $transacciones
     */
    public function __construct($cantPaginas = null, array $errores = array(), $hayError = null, array $transacciones = array())
    {
        $this
            ->setCantPaginas($cantPaginas)
            ->setErrores($errores)
            ->setHayError($hayError)
            ->setTransacciones($transacciones);
    }
    /**
     * Get cantPaginas value
     * @return int|null
     */
    public function getCantPaginas()
    {
        return $this->cantPaginas;
    }
    /**
     * Set cantPaginas value
     * @param int $cantPaginas
     * @return \StructType\TransaccionesWsResult
     */
    public function setCantPaginas($cantPaginas = null)
    {
        // validation for constraint: int
        if (!is_null($cantPaginas) && !is_numeric($cantPaginas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cantPaginas)), __LINE__);
        }
        $this->cantPaginas = $cantPaginas;
        return $this;
    }
    /**
     * Get errores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebServiceError[]|null
     */
    public function getErrores()
    {
        return isset($this->errores) ? $this->errores : null;
    }
    /**
     * Set errores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceError[] $errores
     * @return \StructType\TransaccionesWsResult
     */
    public function setErrores(array $errores = array())
    {
        foreach ($errores as $transaccionesWsResultErroresItem) {
            // validation for constraint: itemType
            if (!$transaccionesWsResultErroresItem instanceof \StructType\WebServiceError) {
                throw new \InvalidArgumentException(sprintf('The errores property can only contain items of \StructType\WebServiceError, "%s" given', is_object($transaccionesWsResultErroresItem) ? get_class($transaccionesWsResultErroresItem) : gettype($transaccionesWsResultErroresItem)), __LINE__);
            }
        }
        if (is_null($errores) || (is_array($errores) && empty($errores))) {
            unset($this->errores);
        } else {
            $this->errores = $errores;
        }
        return $this;
    }
    /**
     * Add item to errores value
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceError $item
     * @return \StructType\TransaccionesWsResult
     */
    public function addToErrores(\StructType\WebServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebServiceError) {
            throw new \InvalidArgumentException(sprintf('The errores property can only contain items of \StructType\WebServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errores[] = $item;
        return $this;
    }
    /**
     * Get hayError value
     * @return bool|null
     */
    public function getHayError()
    {
        return $this->hayError;
    }
    /**
     * Set hayError value
     * @param bool $hayError
     * @return \StructType\TransaccionesWsResult
     */
    public function setHayError($hayError = null)
    {
        // validation for constraint: boolean
        if (!is_null($hayError) && !is_bool($hayError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hayError)), __LINE__);
        }
        $this->hayError = $hayError;
        return $this;
    }
    /**
     * Get transacciones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransaccionSdrnPlain[]|null
     */
    public function getTransacciones()
    {
        return isset($this->transacciones) ? $this->transacciones : null;
    }
    /**
     * Set transacciones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransaccionSdrnPlain[] $transacciones
     * @return \StructType\TransaccionesWsResult
     */
    public function setTransacciones(array $transacciones = array())
    {
        foreach ($transacciones as $transaccionesWsResultTransaccionesItem) {
            // validation for constraint: itemType
            if (!$transaccionesWsResultTransaccionesItem instanceof \StructType\TransaccionSdrnPlain) {
                throw new \InvalidArgumentException(sprintf('The transacciones property can only contain items of \StructType\TransaccionSdrnPlain, "%s" given', is_object($transaccionesWsResultTransaccionesItem) ? get_class($transaccionesWsResultTransaccionesItem) : gettype($transaccionesWsResultTransaccionesItem)), __LINE__);
            }
        }
        if (is_null($transacciones) || (is_array($transacciones) && empty($transacciones))) {
            unset($this->transacciones);
        } else {
            $this->transacciones = $transacciones;
        }
        return $this;
    }
    /**
     * Add item to transacciones value
     * @throws \InvalidArgumentException
     * @param \StructType\TransaccionSdrnPlain $item
     * @return \StructType\TransaccionesWsResult
     */
    public function addToTransacciones(\StructType\TransaccionSdrnPlain $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransaccionSdrnPlain) {
            throw new \InvalidArgumentException(sprintf('The transacciones property can only contain items of \StructType\TransaccionSdrnPlain, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->transacciones[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransaccionesWsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
