<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for catalogoGLNResult StructType
 * @subpackage Structs
 */
class CatalogoGLNResult extends ResultadoPersonalizado
{
    /**
     * The cantPaginas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cantPaginas;
    /**
     * The errores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebServiceError[]
     */
    public $errores;
    /**
     * The hay_error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hay_error;
    /**
     * The list
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AgentePlain[]
     */
    public $list;
    /**
     * Constructor method for catalogoGLNResult
     * @uses CatalogoGLNResult::setCantPaginas()
     * @uses CatalogoGLNResult::setErrores()
     * @uses CatalogoGLNResult::setHay_error()
     * @uses CatalogoGLNResult::setList()
     * @param int $cantPaginas
     * @param \StructType\WebServiceError[] $errores
     * @param bool $hay_error
     * @param \StructType\AgentePlain[] $list
     */
    public function __construct($cantPaginas = null, array $errores = array(), $hay_error = null, array $list = array())
    {
        $this
            ->setCantPaginas($cantPaginas)
            ->setErrores($errores)
            ->setHay_error($hay_error)
            ->setList($list);
    }
    /**
     * Get cantPaginas value
     * @return int|null
     */
    public function getCantPaginas()
    {
        return $this->cantPaginas;
    }
    /**
     * Set cantPaginas value
     * @param int $cantPaginas
     * @return \StructType\CatalogoGLNResult
     */
    public function setCantPaginas($cantPaginas = null)
    {
        // validation for constraint: int
        if (!is_null($cantPaginas) && !is_numeric($cantPaginas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cantPaginas)), __LINE__);
        }
        $this->cantPaginas = $cantPaginas;
        return $this;
    }
    /**
     * Get errores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebServiceError[]|null
     */
    public function getErrores()
    {
        return isset($this->errores) ? $this->errores : null;
    }
    /**
     * Set errores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceError[] $errores
     * @return \StructType\CatalogoGLNResult
     */
    public function setErrores(array $errores = array())
    {
        foreach ($errores as $catalogoGLNResultErroresItem) {
            // validation for constraint: itemType
            if (!$catalogoGLNResultErroresItem instanceof \StructType\WebServiceError) {
                throw new \InvalidArgumentException(sprintf('The errores property can only contain items of \StructType\WebServiceError, "%s" given', is_object($catalogoGLNResultErroresItem) ? get_class($catalogoGLNResultErroresItem) : gettype($catalogoGLNResultErroresItem)), __LINE__);
            }
        }
        if (is_null($errores) || (is_array($errores) && empty($errores))) {
            unset($this->errores);
        } else {
            $this->errores = $errores;
        }
        return $this;
    }
    /**
     * Add item to errores value
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceError $item
     * @return \StructType\CatalogoGLNResult
     */
    public function addToErrores(\StructType\WebServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebServiceError) {
            throw new \InvalidArgumentException(sprintf('The errores property can only contain items of \StructType\WebServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->errores[] = $item;
        return $this;
    }
    /**
     * Get hay_error value
     * @return bool|null
     */
    public function getHay_error()
    {
        return $this->hay_error;
    }
    /**
     * Set hay_error value
     * @param bool $hay_error
     * @return \StructType\CatalogoGLNResult
     */
    public function setHay_error($hay_error = null)
    {
        // validation for constraint: boolean
        if (!is_null($hay_error) && !is_bool($hay_error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hay_error)), __LINE__);
        }
        $this->hay_error = $hay_error;
        return $this;
    }
    /**
     * Get list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AgentePlain[]|null
     */
    public function getList()
    {
        return isset($this->list) ? $this->list : null;
    }
    /**
     * Set list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AgentePlain[] $list
     * @return \StructType\CatalogoGLNResult
     */
    public function setList(array $list = array())
    {
        foreach ($list as $catalogoGLNResultListItem) {
            // validation for constraint: itemType
            if (!$catalogoGLNResultListItem instanceof \StructType\AgentePlain) {
                throw new \InvalidArgumentException(sprintf('The list property can only contain items of \StructType\AgentePlain, "%s" given', is_object($catalogoGLNResultListItem) ? get_class($catalogoGLNResultListItem) : gettype($catalogoGLNResultListItem)), __LINE__);
            }
        }
        if (is_null($list) || (is_array($list) && empty($list))) {
            unset($this->list);
        } else {
            $this->list = $list;
        }
        return $this;
    }
    /**
     * Add item to list value
     * @throws \InvalidArgumentException
     * @param \StructType\AgentePlain $item
     * @return \StructType\CatalogoGLNResult
     */
    public function addToList(\StructType\AgentePlain $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AgentePlain) {
            throw new \InvalidArgumentException(sprintf('The list property can only contain items of \StructType\AgentePlain, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CatalogoGLNResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
