<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getTransaccionesWs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransaccionesWs $parameters
     * @return \StructType\GetTransaccionesWsResponse|bool
     */
    public function getTransaccionesWs(\StructType\GetTransaccionesWs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getTransaccionesWs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCatalogoElectronicoByGTIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCatalogoElectronicoByGTIN $parameters
     * @return \StructType\GetCatalogoElectronicoByGTINResponse|bool
     */
    public function getCatalogoElectronicoByGTIN(\StructType\GetCatalogoElectronicoByGTIN $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCatalogoElectronicoByGTIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOperadores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOperadores $parameters
     * @return \StructType\GetOperadoresResponse|bool
     */
    public function getOperadores(\StructType\GetOperadores $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOperadores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCatalogoElectronicoByGLN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCatalogoElectronicoByGLN $parameters
     * @return \StructType\GetCatalogoElectronicoByGLNResponse|bool
     */
    public function getCatalogoElectronicoByGLN(\StructType\GetCatalogoElectronicoByGLN $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCatalogoElectronicoByGLN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCatalogoElectronicoByGLNResponse|\StructType\GetCatalogoElectronicoByGTINResponse|\StructType\GetOperadoresResponse|\StructType\GetTransaccionesWsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
