<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierRsType StructType
 * @subpackage Structs
 */
class SupplierRsType extends AbstractStructBase
{
    /**
     * The QuotedPartList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\QuotedPartListType
     */
    public $QuotedPartList;
    /**
     * The ComplicationList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ComplicationListType
     */
    public $ComplicationList;
    /**
     * The SupplierRefNum
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string
     */
    public $SupplierRefNum;
    /**
     * Constructor method for SupplierRsType
     * @uses SupplierRsType::setQuotedPartList()
     * @uses SupplierRsType::setComplicationList()
     * @uses SupplierRsType::setSupplierRefNum()
     * @param \StructType\QuotedPartListType $quotedPartList
     * @param \StructType\ComplicationListType $complicationList
     * @param string $supplierRefNum
     */
    public function __construct(\StructType\QuotedPartListType $quotedPartList = null, \StructType\ComplicationListType $complicationList = null, $supplierRefNum = null)
    {
        $this
            ->setQuotedPartList($quotedPartList)
            ->setComplicationList($complicationList)
            ->setSupplierRefNum($supplierRefNum);
    }
    /**
     * Get QuotedPartList value
     * @return \StructType\QuotedPartListType|null
     */
    public function getQuotedPartList()
    {
        return $this->QuotedPartList;
    }
    /**
     * Set QuotedPartList value
     * @param \StructType\QuotedPartListType $quotedPartList
     * @return \StructType\SupplierRsType
     */
    public function setQuotedPartList(\StructType\QuotedPartListType $quotedPartList = null)
    {
        $this->QuotedPartList = $quotedPartList;
        return $this;
    }
    /**
     * Get ComplicationList value
     * @return \StructType\ComplicationListType|null
     */
    public function getComplicationList()
    {
        return $this->ComplicationList;
    }
    /**
     * Set ComplicationList value
     * @param \StructType\ComplicationListType $complicationList
     * @return \StructType\SupplierRsType
     */
    public function setComplicationList(\StructType\ComplicationListType $complicationList = null)
    {
        $this->ComplicationList = $complicationList;
        return $this;
    }
    /**
     * Get SupplierRefNum value
     * @return string|null
     */
    public function getSupplierRefNum()
    {
        return $this->SupplierRefNum;
    }
    /**
     * Set SupplierRefNum value
     * @param string $supplierRefNum
     * @return \StructType\SupplierRsType
     */
    public function setSupplierRefNum($supplierRefNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($supplierRefNum) && strlen($supplierRefNum) > 80) || (is_array($supplierRefNum) && count($supplierRefNum) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($supplierRefNum) ? strlen($supplierRefNum) : count($supplierRefNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($supplierRefNum) && strlen($supplierRefNum) < 1) || (is_array($supplierRefNum) && count($supplierRefNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($supplierRefNum) && !is_string($supplierRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierRefNum)), __LINE__);
        }
        $this->SupplierRefNum = $supplierRefNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplierRsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
