<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotedPartListType StructType
 * @subpackage Structs
 */
class QuotedPartListType extends AbstractStructBase
{
    /**
     * The QuotedPart
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\QuotedPartType[]
     */
    public $QuotedPart;
    /**
     * Constructor method for QuotedPartListType
     * @uses QuotedPartListType::setQuotedPart()
     * @param \StructType\QuotedPartType[] $quotedPart
     */
    public function __construct(array $quotedPart = array())
    {
        $this
            ->setQuotedPart($quotedPart);
    }
    /**
     * Get QuotedPart value
     * @return \StructType\QuotedPartType[]|null
     */
    public function getQuotedPart()
    {
        return $this->QuotedPart;
    }
    /**
     * Set QuotedPart value
     * @throws \InvalidArgumentException
     * @param \StructType\QuotedPartType[] $quotedPart
     * @return \StructType\QuotedPartListType
     */
    public function setQuotedPart(array $quotedPart = array())
    {
        foreach ($quotedPart as $quotedPartListTypeQuotedPartItem) {
            // validation for constraint: itemType
            if (!$quotedPartListTypeQuotedPartItem instanceof \StructType\QuotedPartType) {
                throw new \InvalidArgumentException(sprintf('The QuotedPart property can only contain items of \StructType\QuotedPartType, "%s" given', is_object($quotedPartListTypeQuotedPartItem) ? get_class($quotedPartListTypeQuotedPartItem) : gettype($quotedPartListTypeQuotedPartItem)), __LINE__);
            }
        }
        $this->QuotedPart = $quotedPart;
        return $this;
    }
    /**
     * Add item to QuotedPart value
     * @throws \InvalidArgumentException
     * @param \StructType\QuotedPartType $item
     * @return \StructType\QuotedPartListType
     */
    public function addToQuotedPart(\StructType\QuotedPartType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QuotedPartType) {
            throw new \InvalidArgumentException(sprintf('The QuotedPart property can only contain items of \StructType\QuotedPartType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->QuotedPart[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotedPartListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
