<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcurementFolderType StructType
 * @subpackage Structs
 */
class ProcurementFolderType extends AbstractStructBase
{
    /**
     * The ProcurementFolderID
     * Meta informations extracted from the WSDL
     * - maxLength: 36
     * - minLength: 36 | 1
     * - pattern: ([0-9]|[a-f]|[A-F]){8}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){12} | [\p{IsBasicLatin}]*
     * @var string
     */
    public $ProcurementFolderID;
    /**
     * The ProcurementFolderVerNum
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99
     * - minInclusive: 0
     * @var int
     */
    public $ProcurementFolderVerNum;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The LastModifiedDateTime
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The Header
     * @var \StructType\HeaderType
     */
    public $Header;
    /**
     * The ProcurementInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProcurementInfoType[]
     */
    public $ProcurementInfo;
    /**
     * Constructor method for ProcurementFolderType
     * @uses ProcurementFolderType::setProcurementFolderID()
     * @uses ProcurementFolderType::setProcurementFolderVerNum()
     * @uses ProcurementFolderType::setCreateDateTime()
     * @uses ProcurementFolderType::setLastModifiedDateTime()
     * @uses ProcurementFolderType::setHeader()
     * @uses ProcurementFolderType::setProcurementInfo()
     * @param string $procurementFolderID
     * @param int $procurementFolderVerNum
     * @param string $createDateTime
     * @param string $lastModifiedDateTime
     * @param \StructType\HeaderType $header
     * @param \StructType\ProcurementInfoType[] $procurementInfo
     */
    public function __construct($procurementFolderID = null, $procurementFolderVerNum = null, $createDateTime = null, $lastModifiedDateTime = null, \StructType\HeaderType $header = null, array $procurementInfo = array())
    {
        $this
            ->setProcurementFolderID($procurementFolderID)
            ->setProcurementFolderVerNum($procurementFolderVerNum)
            ->setCreateDateTime($createDateTime)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setHeader($header)
            ->setProcurementInfo($procurementInfo);
    }
    /**
     * Get ProcurementFolderID value
     * @return string|null
     */
    public function getProcurementFolderID()
    {
        return $this->ProcurementFolderID;
    }
    /**
     * Set ProcurementFolderID value
     * @param string $procurementFolderID
     * @return \StructType\ProcurementFolderType
     */
    public function setProcurementFolderID($procurementFolderID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($procurementFolderID) && strlen($procurementFolderID) > 36) || (is_array($procurementFolderID) && count($procurementFolderID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($procurementFolderID) ? strlen($procurementFolderID) : count($procurementFolderID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($procurementFolderID) && strlen($procurementFolderID) < 1) || (is_array($procurementFolderID) && count($procurementFolderID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($procurementFolderID) && !preg_match('//', $procurementFolderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "Array", "%s" given', var_export($procurementFolderID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($procurementFolderID) && !is_string($procurementFolderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($procurementFolderID)), __LINE__);
        }
        $this->ProcurementFolderID = $procurementFolderID;
        return $this;
    }
    /**
     * Get ProcurementFolderVerNum value
     * @return int|null
     */
    public function getProcurementFolderVerNum()
    {
        return $this->ProcurementFolderVerNum;
    }
    /**
     * Set ProcurementFolderVerNum value
     * @param int $procurementFolderVerNum
     * @return \StructType\ProcurementFolderType
     */
    public function setProcurementFolderVerNum($procurementFolderVerNum = null)
    {
        // validation for constraint: maxInclusive
        if ($procurementFolderVerNum > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99, "%s" given', $procurementFolderVerNum), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($procurementFolderVerNum < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $procurementFolderVerNum), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($procurementFolderVerNum) && !is_numeric($procurementFolderVerNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($procurementFolderVerNum)), __LINE__);
        }
        $this->ProcurementFolderVerNum = $procurementFolderVerNum;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\ProcurementFolderType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return $this->LastModifiedDateTime;
    }
    /**
     * Set LastModifiedDateTime value
     * @param string $lastModifiedDateTime
     * @return \StructType\ProcurementFolderType
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifiedDateTime)), __LINE__);
        }
        $this->LastModifiedDateTime = $lastModifiedDateTime;
        return $this;
    }
    /**
     * Get Header value
     * @return \StructType\HeaderType|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \StructType\HeaderType $header
     * @return \StructType\ProcurementFolderType
     */
    public function setHeader(\StructType\HeaderType $header = null)
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Get ProcurementInfo value
     * @return \StructType\ProcurementInfoType[]|null
     */
    public function getProcurementInfo()
    {
        return $this->ProcurementInfo;
    }
    /**
     * Set ProcurementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcurementInfoType[] $procurementInfo
     * @return \StructType\ProcurementFolderType
     */
    public function setProcurementInfo(array $procurementInfo = array())
    {
        foreach ($procurementInfo as $procurementFolderTypeProcurementInfoItem) {
            // validation for constraint: itemType
            if (!$procurementFolderTypeProcurementInfoItem instanceof \StructType\ProcurementInfoType) {
                throw new \InvalidArgumentException(sprintf('The ProcurementInfo property can only contain items of \StructType\ProcurementInfoType, "%s" given', is_object($procurementFolderTypeProcurementInfoItem) ? get_class($procurementFolderTypeProcurementInfoItem) : gettype($procurementFolderTypeProcurementInfoItem)), __LINE__);
            }
        }
        $this->ProcurementInfo = $procurementInfo;
        return $this;
    }
    /**
     * Add item to ProcurementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcurementInfoType $item
     * @return \StructType\ProcurementFolderType
     */
    public function addToProcurementInfo(\StructType\ProcurementInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProcurementInfoType) {
            throw new \InvalidArgumentException(sprintf('The ProcurementInfo property can only contain items of \StructType\ProcurementInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProcurementInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcurementFolderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
