<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceInfoType StructType
 * @subpackage Structs
 */
class PriceInfoType extends AbstractStructBase
{
    /**
     * The UnitListPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $UnitListPrice;
    /**
     * The UnitNetPrice
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $UnitNetPrice;
    /**
     * Constructor method for PriceInfoType
     * @uses PriceInfoType::setUnitListPrice()
     * @uses PriceInfoType::setUnitNetPrice()
     * @param float $unitListPrice
     * @param float $unitNetPrice
     */
    public function __construct($unitListPrice = null, $unitNetPrice = null)
    {
        $this
            ->setUnitListPrice($unitListPrice)
            ->setUnitNetPrice($unitNetPrice);
    }
    /**
     * Get UnitListPrice value
     * @return float|null
     */
    public function getUnitListPrice()
    {
        return $this->UnitListPrice;
    }
    /**
     * Set UnitListPrice value
     * @param float $unitListPrice
     * @return \StructType\PriceInfoType
     */
    public function setUnitListPrice($unitListPrice = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($unitListPrice) && strlen(substr($unitListPrice, strpos($unitListPrice, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($unitListPrice, strpos($unitListPrice, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($unitListPrice) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $unitListPrice)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($unitListPrice, strpos($unitListPrice, '.')))), __LINE__);
        }
        $this->UnitListPrice = $unitListPrice;
        return $this;
    }
    /**
     * Get UnitNetPrice value
     * @return float|null
     */
    public function getUnitNetPrice()
    {
        return $this->UnitNetPrice;
    }
    /**
     * Set UnitNetPrice value
     * @param float $unitNetPrice
     * @return \StructType\PriceInfoType
     */
    public function setUnitNetPrice($unitNetPrice = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($unitNetPrice) && strlen(substr($unitNetPrice, strpos($unitNetPrice, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($unitNetPrice, strpos($unitNetPrice, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($unitNetPrice) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $unitNetPrice)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($unitNetPrice, strpos($unitNetPrice, '.')))), __LINE__);
        }
        $this->UnitNetPrice = $unitNetPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
