<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartNumInfoType StructType
 * @subpackage Structs
 */
class PartNumInfoType extends AbstractStructBase
{
    /**
     * The PartNumType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: [AAIA] : [Aftermarket Automotive Industry Association] [Aftermarket] : [Aftermarket] [Cardone] : [Aftermarket Mechanical] [CarPart] : [CarPart] [EstimatingSystem] : [Estimating System] [HollanderInterchange] : [Hollander Interchange]
     * [NAGS] : [National Auto Glass Specification] [OE] : [Original Equipment Manufacturer] [PartsLink] : [Parts Link, Keystone] [Recycle] : [Recycle] [Stock] : [Stock (Inventory Reference Number)]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $PartNumType;
    /**
     * The PartNum
     * Meta informations extracted from the WSDL
     * - maxLength: 45
     * - minLength: 1 | 1
     * @var string
     */
    public $PartNum;
    /**
     * Constructor method for PartNumInfoType
     * @uses PartNumInfoType::setPartNumType()
     * @uses PartNumInfoType::setPartNum()
     * @param string $partNumType
     * @param string $partNum
     */
    public function __construct($partNumType = null, $partNum = null)
    {
        $this
            ->setPartNumType($partNumType)
            ->setPartNum($partNum);
    }
    /**
     * Get PartNumType value
     * @return string|null
     */
    public function getPartNumType()
    {
        return $this->PartNumType;
    }
    /**
     * Set PartNumType value
     * @param string $partNumType
     * @return \StructType\PartNumInfoType
     */
    public function setPartNumType($partNumType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partNumType) && strlen($partNumType) > 80) || (is_array($partNumType) && count($partNumType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($partNumType) ? strlen($partNumType) : count($partNumType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partNumType) && strlen($partNumType) < 1) || (is_array($partNumType) && count($partNumType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($partNumType) && !preg_match('/[\\p{IsBasicLatin}]*/', $partNumType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($partNumType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partNumType) && !is_string($partNumType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partNumType)), __LINE__);
        }
        $this->PartNumType = $partNumType;
        return $this;
    }
    /**
     * Get PartNum value
     * @return string|null
     */
    public function getPartNum()
    {
        return $this->PartNum;
    }
    /**
     * Set PartNum value
     * @param string $partNum
     * @return \StructType\PartNumInfoType
     */
    public function setPartNum($partNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partNum) && strlen($partNum) > 45) || (is_array($partNum) && count($partNum) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($partNum) ? strlen($partNum) : count($partNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partNum) && strlen($partNum) < 1) || (is_array($partNum) && count($partNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partNum) && !is_string($partNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partNum)), __LINE__);
        }
        $this->PartNum = $partNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartNumInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
