<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherPartyType StructType
 * @subpackage Structs
 */
class OtherPartyType extends AbstractStructBase
{
    /**
     * The Party
     * @var \StructType\PartyType
     */
    public $Party;
    /**
     * The AdminType
     * Meta informations extracted from the WSDL
     * - maxLength: 3
     * - minLength: 3 | 1
     * @var string
     */
    public $AdminType;
    /**
     * Constructor method for OtherPartyType
     * @uses OtherPartyType::setParty()
     * @uses OtherPartyType::setAdminType()
     * @param \StructType\PartyType $party
     * @param string $adminType
     */
    public function __construct(\StructType\PartyType $party = null, $adminType = null)
    {
        $this
            ->setParty($party)
            ->setAdminType($adminType);
    }
    /**
     * Get Party value
     * @return \StructType\PartyType|null
     */
    public function getParty()
    {
        return $this->Party;
    }
    /**
     * Set Party value
     * @param \StructType\PartyType $party
     * @return \StructType\OtherPartyType
     */
    public function setParty(\StructType\PartyType $party = null)
    {
        $this->Party = $party;
        return $this;
    }
    /**
     * Get AdminType value
     * @return string|null
     */
    public function getAdminType()
    {
        return $this->AdminType;
    }
    /**
     * Set AdminType value
     * @param string $adminType
     * @return \StructType\OtherPartyType
     */
    public function setAdminType($adminType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($adminType) && strlen($adminType) > 3) || (is_array($adminType) && count($adminType) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($adminType) ? strlen($adminType) : count($adminType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($adminType) && strlen($adminType) < 1) || (is_array($adminType) && count($adminType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adminType) && !is_string($adminType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adminType)), __LINE__);
        }
        $this->AdminType = $adminType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherPartyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
