<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdometerInfoType StructType
 * @subpackage Structs
 */
class OdometerInfoType extends AbstractStructBase
{
    /**
     * The OdometerInd
     * @var bool
     */
    public $OdometerInd;
    /**
     * The OdometerReading
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 9999999
     * - minInclusive: 0
     * @var int
     */
    public $OdometerReading;
    /**
     * Constructor method for OdometerInfoType
     * @uses OdometerInfoType::setOdometerInd()
     * @uses OdometerInfoType::setOdometerReading()
     * @param bool $odometerInd
     * @param int $odometerReading
     */
    public function __construct($odometerInd = null, $odometerReading = null)
    {
        $this
            ->setOdometerInd($odometerInd)
            ->setOdometerReading($odometerReading);
    }
    /**
     * Get OdometerInd value
     * @return bool|null
     */
    public function getOdometerInd()
    {
        return $this->OdometerInd;
    }
    /**
     * Set OdometerInd value
     * @param bool $odometerInd
     * @return \StructType\OdometerInfoType
     */
    public function setOdometerInd($odometerInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($odometerInd) && !is_bool($odometerInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($odometerInd)), __LINE__);
        }
        $this->OdometerInd = $odometerInd;
        return $this;
    }
    /**
     * Get OdometerReading value
     * @return int|null
     */
    public function getOdometerReading()
    {
        return $this->OdometerReading;
    }
    /**
     * Set OdometerReading value
     * @param int $odometerReading
     * @return \StructType\OdometerInfoType
     */
    public function setOdometerReading($odometerReading = null)
    {
        // validation for constraint: maxInclusive
        if ($odometerReading > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999, "%s" given', $odometerReading), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($odometerReading < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $odometerReading), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($odometerReading) && !is_numeric($odometerReading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($odometerReading)), __LINE__);
        }
        $this->OdometerReading = $odometerReading;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OdometerInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
