<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageHeaderType StructType
 * @subpackage Structs
 */
class MessageHeaderType extends AbstractStructBase
{
    /**
     * The RqUID
     * Meta informations extracted from the WSDL
     * - maxLength: 36
     * - minLength: 36 | 1
     * - pattern: ([0-9]|[a-f]|[A-F]){8}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){12} | [\p{IsBasicLatin}]*
     * @var string
     */
    public $RqUID;
    /**
     * The AsyncRqUID
     * Meta informations extracted from the WSDL
     * - maxLength: 36
     * - minLength: 36 | 1
     * - pattern: ([0-9]|[a-f]|[A-F]){8}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){12} | [\p{IsBasicLatin}]*
     * @var string
     */
    public $AsyncRqUID;
    /**
     * The PartnerKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 36
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $PartnerKey;
    /**
     * Constructor method for MessageHeaderType
     * @uses MessageHeaderType::setRqUID()
     * @uses MessageHeaderType::setAsyncRqUID()
     * @uses MessageHeaderType::setPartnerKey()
     * @param string $rqUID
     * @param string $asyncRqUID
     * @param string $partnerKey
     */
    public function __construct($rqUID = null, $asyncRqUID = null, $partnerKey = null)
    {
        $this
            ->setRqUID($rqUID)
            ->setAsyncRqUID($asyncRqUID)
            ->setPartnerKey($partnerKey);
    }
    /**
     * Get RqUID value
     * @return string|null
     */
    public function getRqUID()
    {
        return $this->RqUID;
    }
    /**
     * Set RqUID value
     * @param string $rqUID
     * @return \StructType\MessageHeaderType
     */
    public function setRqUID($rqUID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rqUID) && strlen($rqUID) > 36) || (is_array($rqUID) && count($rqUID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($rqUID) ? strlen($rqUID) : count($rqUID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($rqUID) && strlen($rqUID) < 1) || (is_array($rqUID) && count($rqUID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($rqUID) && !preg_match('//', $rqUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "Array", "%s" given', var_export($rqUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rqUID) && !is_string($rqUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rqUID)), __LINE__);
        }
        $this->RqUID = $rqUID;
        return $this;
    }
    /**
     * Get AsyncRqUID value
     * @return string|null
     */
    public function getAsyncRqUID()
    {
        return $this->AsyncRqUID;
    }
    /**
     * Set AsyncRqUID value
     * @param string $asyncRqUID
     * @return \StructType\MessageHeaderType
     */
    public function setAsyncRqUID($asyncRqUID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asyncRqUID) && strlen($asyncRqUID) > 36) || (is_array($asyncRqUID) && count($asyncRqUID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($asyncRqUID) ? strlen($asyncRqUID) : count($asyncRqUID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($asyncRqUID) && strlen($asyncRqUID) < 1) || (is_array($asyncRqUID) && count($asyncRqUID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($asyncRqUID) && !preg_match('//', $asyncRqUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "Array", "%s" given', var_export($asyncRqUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asyncRqUID) && !is_string($asyncRqUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asyncRqUID)), __LINE__);
        }
        $this->AsyncRqUID = $asyncRqUID;
        return $this;
    }
    /**
     * Get PartnerKey value
     * @return string|null
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }
    /**
     * Set PartnerKey value
     * @param string $partnerKey
     * @return \StructType\MessageHeaderType
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partnerKey) && strlen($partnerKey) > 36) || (is_array($partnerKey) && count($partnerKey) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($partnerKey) ? strlen($partnerKey) : count($partnerKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partnerKey) && strlen($partnerKey) < 1) || (is_array($partnerKey) && count($partnerKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($partnerKey) && !preg_match('/[\\p{IsBasicLatin}]*/', $partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($partnerKey, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerKey)), __LINE__);
        }
        $this->PartnerKey = $partnerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
