<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocAttachmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Allows the transmission of attachment files in several ways. There is flexibility to transmit the attachments in either a legacy, or more modern transport model, including the flexibility of base 64 binary, and MIME for future growth
 * @subpackage Structs
 */
class DocAttachmentType extends AbstractStructBase
{
    /**
     * The AttachmentType
     * Meta informations extracted from the WSDL
     * - documentation: [Adjusters Notes] : [Adjusters Notes] [Applicant Recorded Statement] : [Applicant Recorded Statement] [Applicant Written Statement] : [Applicant Written Statement] [Asset Report] : [Asset Report] [Bailment Form] : [Bailment Form]
     * [Case Law] : [Case Law or Statutes] [Cause Of Orgin] : [This code is Obsolete. Correct usage is Origin and Cause. This remains here for backward compatibility. Cause And Origin/Origin And Cause from an expert opinion, this is the root cause. i.e.,
     * recall, brakes, engine failure.] [CD] : [Condition] [Compliance Report] : [Compliance Report] [Contentions] : [Contentions (legal term is also Brief), this is created and attached in the Alternative Dispute Resolution vendor. This is the body of the
     * argument why the demand is justified.] [Deductible] : [Deductible] [Denial Letter] : [Denial Letter] [Dimished Value Documentation] : [Dimished Value Documentation] [DMV Report] : [Department of Motor Vehicle Report. This reports on the vehicle owner
     * and the vehicle itself. It does not report on the accident itself, that is done in the police report.] [Email] : [Emails that have been received] [ES] : [Estimate Data File] [Expert Report] : [Expert Report] [Final Closing Report] : [Final Closing
     * Report] [Fire Department Report] : [Fire Department Report] [FR] : [Frame measurements] [IN] : [Invoices] [Insureds Out Of Pocket Expenses] : [Insured's Out Of Pocket Expenses that were incurred as a result of the accident] [Letter Of Guarantee] :
     * [Letter Of Guarantee] [Letters] : [Letters that have been received] [Lien Release Document] : [Lien Release Document] [Loss of Use Provision] : [Loss of Use Provision] [Medical Report] : [Medical Report] [MI] : [Miscellaneous, Other] [Motor Vehicle
     * Accident Report] : [Motor Vehicle Accident Report, also called an Incident Report, normally completed by carriers insured. This is not the DMV report.] [Origin and Cause] : [Cause And Origin/Origin And Cause from an expert opinion, this is the root
     * cause. i.e., recall, brakes, engine failure] [Payment History] : [Payment History] [PH] : [Photo images, Photograph(s)] [PI] : [Estimate print image, Estimate] [PO] : [Purchase order] [POA] : [Power of Attorney] [Police Report] : [Police Report
     * reports on the accident, people involved and other facts about the accident.] [Policy Cancellation Letter] : [Policy Cancellation Letter] [Policy Declarations] : [Policy Declarations] [Policy Language] : [Policy Language] [Proof of Damages] : [Proof
     * of Damages] [Proof Of Payment] : [Proof Of Payment, copy of a check, etc.] [Rental Bill Receipt] : [Rental Bill Receipt] [Reservation of Rights Letter] : [Reservation of Rights Letter] [Respondent Recorded Statement] : [Respondent Recorded Statement]
     * [Respondent Written Statement] : [Respondent Written Statement] [RO] : [Repair order] [Rules of the Road] : [Rules of the Road] [Salvage Invoice] : [Salvage Invoice] [Salvage Report] : [Salvage Report] [Scene Diagram] : [Scene Diagram] [Scene
     * Photograph(s)] : [Scene Photograph(s)] [Skip Trace Report] : [Skip Trace Report] [Statement] : [Statement] [Statute] : [Statute] [Subrogation Support Document] : [This document supports the Subrogation claim. Examples include sited Tort Law and Court
     * Settlement examples. (e.g., failure to yield the right of way � case of loss, claimed to have been violated or the tort law and other case settlements)] [Supplemental Payments] : [Supplemental Payments] [Title] : [This is a vehicle's title] [Towing
     * and/or Storage Bill] : [Towing and/or Storage Bill] [Towing Invoice Generated] : [This is a generated towing invoice] [Towing Invoice Original] : [This is an original towing invoice] [Transmittal Report] : [Transmittal Report] [TV] : [Valuation,
     * Total Loss Valuation] [Vehicle Damage] : [Vehicle Damage] [VIR] : [Vehicle Inspection Report] [Witness Statement] : [Witness Recorded Statement] [Witness Written Statement] : [Witness Written Statement]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $AttachmentType;
    /**
     * The AttachmentTitle
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * - minLength: 1 | 1
     * @var string
     */
    public $AttachmentTitle;
    /**
     * The AttachmentMemo
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $AttachmentMemo;
    /**
     * The CreateDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CaptureDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CaptureDateTime;
    /**
     * The AttachmentFileType
     * Meta informations extracted from the WSDL
     * - documentation: [BMS] : [BMS XML file] [COMPRESSED FILE] : [Compressed files (i.e. *.zip)] [COMPRESSED IMAGE] : [Compressed image file format (all versions) (i.e. *.jpg)] [CSV] : [Comma separated data files] [HTML] : [Hypertext formatted documents]
     * [IMAGE] : [Image file format (all formats non-compressed)] [MUSIC] : [Music formatted file types, all versions] [OTHER] : [Other] [PDF] : [Portable Document Format] [SPREADSHEET] : [Spreadsheet documents (all versions)] [TEXT] : [Text files] [WORD] :
     * [Word processor documents (all versions)] [XML] : [Any XML file other than the BMS]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $AttachmentFileType;
    /**
     * The AttachmentFileName
     * Meta informations extracted from the WSDL
     * - maxLength: 256
     * - minLength: 1 | 1
     * @var string
     */
    public $AttachmentFileName;
    /**
     * The AttachmentURI
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $AttachmentURI;
    /**
     * Constructor method for DocAttachmentType
     * @uses DocAttachmentType::setAttachmentType()
     * @uses DocAttachmentType::setAttachmentTitle()
     * @uses DocAttachmentType::setAttachmentMemo()
     * @uses DocAttachmentType::setCreateDateTime()
     * @uses DocAttachmentType::setCaptureDateTime()
     * @uses DocAttachmentType::setAttachmentFileType()
     * @uses DocAttachmentType::setAttachmentFileName()
     * @uses DocAttachmentType::setAttachmentURI()
     * @param string $attachmentType
     * @param string $attachmentTitle
     * @param string $attachmentMemo
     * @param string $createDateTime
     * @param string $captureDateTime
     * @param string $attachmentFileType
     * @param string $attachmentFileName
     * @param string $attachmentURI
     */
    public function __construct($attachmentType = null, $attachmentTitle = null, $attachmentMemo = null, $createDateTime = null, $captureDateTime = null, $attachmentFileType = null, $attachmentFileName = null, $attachmentURI = null)
    {
        $this
            ->setAttachmentType($attachmentType)
            ->setAttachmentTitle($attachmentTitle)
            ->setAttachmentMemo($attachmentMemo)
            ->setCreateDateTime($createDateTime)
            ->setCaptureDateTime($captureDateTime)
            ->setAttachmentFileType($attachmentFileType)
            ->setAttachmentFileName($attachmentFileName)
            ->setAttachmentURI($attachmentURI);
    }
    /**
     * Get AttachmentType value
     * @return string|null
     */
    public function getAttachmentType()
    {
        return $this->AttachmentType;
    }
    /**
     * Set AttachmentType value
     * @param string $attachmentType
     * @return \StructType\DocAttachmentType
     */
    public function setAttachmentType($attachmentType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentType) && strlen($attachmentType) > 80) || (is_array($attachmentType) && count($attachmentType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($attachmentType) ? strlen($attachmentType) : count($attachmentType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentType) && strlen($attachmentType) < 1) || (is_array($attachmentType) && count($attachmentType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($attachmentType) && !preg_match('/[\\p{IsBasicLatin}]*/', $attachmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($attachmentType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentType) && !is_string($attachmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentType)), __LINE__);
        }
        $this->AttachmentType = $attachmentType;
        return $this;
    }
    /**
     * Get AttachmentTitle value
     * @return string|null
     */
    public function getAttachmentTitle()
    {
        return $this->AttachmentTitle;
    }
    /**
     * Set AttachmentTitle value
     * @param string $attachmentTitle
     * @return \StructType\DocAttachmentType
     */
    public function setAttachmentTitle($attachmentTitle = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentTitle) && strlen($attachmentTitle) > 40) || (is_array($attachmentTitle) && count($attachmentTitle) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($attachmentTitle) ? strlen($attachmentTitle) : count($attachmentTitle)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentTitle) && strlen($attachmentTitle) < 1) || (is_array($attachmentTitle) && count($attachmentTitle) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentTitle) && !is_string($attachmentTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentTitle)), __LINE__);
        }
        $this->AttachmentTitle = $attachmentTitle;
        return $this;
    }
    /**
     * Get AttachmentMemo value
     * @return string|null
     */
    public function getAttachmentMemo()
    {
        return $this->AttachmentMemo;
    }
    /**
     * Set AttachmentMemo value
     * @param string $attachmentMemo
     * @return \StructType\DocAttachmentType
     */
    public function setAttachmentMemo($attachmentMemo = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($attachmentMemo) && strlen($attachmentMemo) < 1) || (is_array($attachmentMemo) && count($attachmentMemo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentMemo) && !is_string($attachmentMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentMemo)), __LINE__);
        }
        $this->AttachmentMemo = $attachmentMemo;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\DocAttachmentType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CaptureDateTime value
     * @return string|null
     */
    public function getCaptureDateTime()
    {
        return $this->CaptureDateTime;
    }
    /**
     * Set CaptureDateTime value
     * @param string $captureDateTime
     * @return \StructType\DocAttachmentType
     */
    public function setCaptureDateTime($captureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($captureDateTime) && !is_string($captureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($captureDateTime)), __LINE__);
        }
        $this->CaptureDateTime = $captureDateTime;
        return $this;
    }
    /**
     * Get AttachmentFileType value
     * @return string|null
     */
    public function getAttachmentFileType()
    {
        return $this->AttachmentFileType;
    }
    /**
     * Set AttachmentFileType value
     * @param string $attachmentFileType
     * @return \StructType\DocAttachmentType
     */
    public function setAttachmentFileType($attachmentFileType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentFileType) && strlen($attachmentFileType) > 80) || (is_array($attachmentFileType) && count($attachmentFileType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($attachmentFileType) ? strlen($attachmentFileType) : count($attachmentFileType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentFileType) && strlen($attachmentFileType) < 1) || (is_array($attachmentFileType) && count($attachmentFileType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($attachmentFileType) && !preg_match('/[\\p{IsBasicLatin}]*/', $attachmentFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($attachmentFileType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentFileType) && !is_string($attachmentFileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentFileType)), __LINE__);
        }
        $this->AttachmentFileType = $attachmentFileType;
        return $this;
    }
    /**
     * Get AttachmentFileName value
     * @return string|null
     */
    public function getAttachmentFileName()
    {
        return $this->AttachmentFileName;
    }
    /**
     * Set AttachmentFileName value
     * @param string $attachmentFileName
     * @return \StructType\DocAttachmentType
     */
    public function setAttachmentFileName($attachmentFileName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentFileName) && strlen($attachmentFileName) > 256) || (is_array($attachmentFileName) && count($attachmentFileName) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($attachmentFileName) ? strlen($attachmentFileName) : count($attachmentFileName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentFileName) && strlen($attachmentFileName) < 1) || (is_array($attachmentFileName) && count($attachmentFileName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentFileName) && !is_string($attachmentFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentFileName)), __LINE__);
        }
        $this->AttachmentFileName = $attachmentFileName;
        return $this;
    }
    /**
     * Get AttachmentURI value
     * @return string|null
     */
    public function getAttachmentURI()
    {
        return $this->AttachmentURI;
    }
    /**
     * Set AttachmentURI value
     * @param string $attachmentURI
     * @return \StructType\DocAttachmentType
     */
    public function setAttachmentURI($attachmentURI = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($attachmentURI) && strlen($attachmentURI) < 1) || (is_array($attachmentURI) && count($attachmentURI) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentURI) && !is_string($attachmentURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentURI)), __LINE__);
        }
        $this->AttachmentURI = $attachmentURI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocAttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
