<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfoType StructType
 * @subpackage Structs
 */
class ContactInfoType extends AbstractStructBase
{
    /**
     * The ContactJobTitle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * - minLength: 1 | 1
     * @var string
     */
    public $ContactJobTitle;
    /**
     * The Communications
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommType[]
     */
    public $Communications;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $ContactName;
    /**
     * Constructor method for ContactInfoType
     * @uses ContactInfoType::setContactJobTitle()
     * @uses ContactInfoType::setCommunications()
     * @uses ContactInfoType::setContactName()
     * @param string $contactJobTitle
     * @param \StructType\CommType[] $communications
     * @param \StructType\PersonNameType $contactName
     */
    public function __construct($contactJobTitle = null, array $communications = array(), \StructType\PersonNameType $contactName = null)
    {
        $this
            ->setContactJobTitle($contactJobTitle)
            ->setCommunications($communications)
            ->setContactName($contactName);
    }
    /**
     * Get ContactJobTitle value
     * @return string|null
     */
    public function getContactJobTitle()
    {
        return $this->ContactJobTitle;
    }
    /**
     * Set ContactJobTitle value
     * @param string $contactJobTitle
     * @return \StructType\ContactInfoType
     */
    public function setContactJobTitle($contactJobTitle = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactJobTitle) && strlen($contactJobTitle) > 32) || (is_array($contactJobTitle) && count($contactJobTitle) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($contactJobTitle) ? strlen($contactJobTitle) : count($contactJobTitle)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contactJobTitle) && strlen($contactJobTitle) < 1) || (is_array($contactJobTitle) && count($contactJobTitle) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactJobTitle) && !is_string($contactJobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactJobTitle)), __LINE__);
        }
        $this->ContactJobTitle = $contactJobTitle;
        return $this;
    }
    /**
     * Get Communications value
     * @return \StructType\CommType[]|null
     */
    public function getCommunications()
    {
        return $this->Communications;
    }
    /**
     * Set Communications value
     * @throws \InvalidArgumentException
     * @param \StructType\CommType[] $communications
     * @return \StructType\ContactInfoType
     */
    public function setCommunications(array $communications = array())
    {
        foreach ($communications as $contactInfoTypeCommunicationsItem) {
            // validation for constraint: itemType
            if (!$contactInfoTypeCommunicationsItem instanceof \StructType\CommType) {
                throw new \InvalidArgumentException(sprintf('The Communications property can only contain items of \StructType\CommType, "%s" given', is_object($contactInfoTypeCommunicationsItem) ? get_class($contactInfoTypeCommunicationsItem) : gettype($contactInfoTypeCommunicationsItem)), __LINE__);
            }
        }
        $this->Communications = $communications;
        return $this;
    }
    /**
     * Add item to Communications value
     * @throws \InvalidArgumentException
     * @param \StructType\CommType $item
     * @return \StructType\ContactInfoType
     */
    public function addToCommunications(\StructType\CommType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommType) {
            throw new \InvalidArgumentException(sprintf('The Communications property can only contain items of \StructType\CommType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Communications[] = $item;
        return $this;
    }
    /**
     * Get ContactName value
     * @return \StructType\PersonNameType|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param \StructType\PersonNameType $contactName
     * @return \StructType\ContactInfoType
     */
    public function setContactName(\StructType\PersonNameType $contactName = null)
    {
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
