<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AftermarketInfoType StructType
 * @subpackage Structs
 */
class AftermarketInfoType extends AbstractStructBase
{
    /**
     * The Manufacturer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string[]
     */
    public $Manufacturer;
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string[]
     */
    public $Brand;
    /**
     * The PartCertification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PartCertificationType[]
     */
    public $PartCertification;
    /**
     * The VendorCertification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PartCertificationType[]
     */
    public $VendorCertification;
    /**
     * Constructor method for AftermarketInfoType
     * @uses AftermarketInfoType::setManufacturer()
     * @uses AftermarketInfoType::setBrand()
     * @uses AftermarketInfoType::setPartCertification()
     * @uses AftermarketInfoType::setVendorCertification()
     * @param string[] $manufacturer
     * @param string[] $brand
     * @param \StructType\PartCertificationType[] $partCertification
     * @param \StructType\PartCertificationType[] $vendorCertification
     */
    public function __construct(array $manufacturer = array(), array $brand = array(), array $partCertification = array(), array $vendorCertification = array())
    {
        $this
            ->setManufacturer($manufacturer)
            ->setBrand($brand)
            ->setPartCertification($partCertification)
            ->setVendorCertification($vendorCertification);
    }
    /**
     * Get Manufacturer value
     * @return string[]|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @throws \InvalidArgumentException
     * @param string[] $manufacturer
     * @return \StructType\AftermarketInfoType
     */
    public function setManufacturer(array $manufacturer = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($manufacturer) && strlen($manufacturer) > 80) || (is_array($manufacturer) && count($manufacturer) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($manufacturer) ? strlen($manufacturer) : count($manufacturer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($manufacturer) && strlen($manufacturer) < 1) || (is_array($manufacturer) && count($manufacturer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($manufacturer as $aftermarketInfoTypeManufacturerItem) {
            // validation for constraint: itemType
            if (!is_string($aftermarketInfoTypeManufacturerItem)) {
                throw new \InvalidArgumentException(sprintf('The Manufacturer property can only contain items of string, "%s" given', is_object($aftermarketInfoTypeManufacturerItem) ? get_class($aftermarketInfoTypeManufacturerItem) : gettype($aftermarketInfoTypeManufacturerItem)), __LINE__);
            }
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Add item to Manufacturer value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AftermarketInfoType
     */
    public function addToManufacturer($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 80) || (is_array($item) && count($item) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Manufacturer property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Manufacturer[] = $item;
        return $this;
    }
    /**
     * Get Brand value
     * @return string[]|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @throws \InvalidArgumentException
     * @param string[] $brand
     * @return \StructType\AftermarketInfoType
     */
    public function setBrand(array $brand = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($brand) && strlen($brand) > 80) || (is_array($brand) && count($brand) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($brand) ? strlen($brand) : count($brand)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($brand) && strlen($brand) < 1) || (is_array($brand) && count($brand) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($brand as $aftermarketInfoTypeBrandItem) {
            // validation for constraint: itemType
            if (!is_string($aftermarketInfoTypeBrandItem)) {
                throw new \InvalidArgumentException(sprintf('The Brand property can only contain items of string, "%s" given', is_object($aftermarketInfoTypeBrandItem) ? get_class($aftermarketInfoTypeBrandItem) : gettype($aftermarketInfoTypeBrandItem)), __LINE__);
            }
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Add item to Brand value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AftermarketInfoType
     */
    public function addToBrand($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 80) || (is_array($item) && count($item) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Brand property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Brand[] = $item;
        return $this;
    }
    /**
     * Get PartCertification value
     * @return \StructType\PartCertificationType[]|null
     */
    public function getPartCertification()
    {
        return $this->PartCertification;
    }
    /**
     * Set PartCertification value
     * @throws \InvalidArgumentException
     * @param \StructType\PartCertificationType[] $partCertification
     * @return \StructType\AftermarketInfoType
     */
    public function setPartCertification(array $partCertification = array())
    {
        foreach ($partCertification as $aftermarketInfoTypePartCertificationItem) {
            // validation for constraint: itemType
            if (!$aftermarketInfoTypePartCertificationItem instanceof \StructType\PartCertificationType) {
                throw new \InvalidArgumentException(sprintf('The PartCertification property can only contain items of \StructType\PartCertificationType, "%s" given', is_object($aftermarketInfoTypePartCertificationItem) ? get_class($aftermarketInfoTypePartCertificationItem) : gettype($aftermarketInfoTypePartCertificationItem)), __LINE__);
            }
        }
        $this->PartCertification = $partCertification;
        return $this;
    }
    /**
     * Add item to PartCertification value
     * @throws \InvalidArgumentException
     * @param \StructType\PartCertificationType $item
     * @return \StructType\AftermarketInfoType
     */
    public function addToPartCertification(\StructType\PartCertificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartCertificationType) {
            throw new \InvalidArgumentException(sprintf('The PartCertification property can only contain items of \StructType\PartCertificationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartCertification[] = $item;
        return $this;
    }
    /**
     * Get VendorCertification value
     * @return \StructType\PartCertificationType[]|null
     */
    public function getVendorCertification()
    {
        return $this->VendorCertification;
    }
    /**
     * Set VendorCertification value
     * @throws \InvalidArgumentException
     * @param \StructType\PartCertificationType[] $vendorCertification
     * @return \StructType\AftermarketInfoType
     */
    public function setVendorCertification(array $vendorCertification = array())
    {
        foreach ($vendorCertification as $aftermarketInfoTypeVendorCertificationItem) {
            // validation for constraint: itemType
            if (!$aftermarketInfoTypeVendorCertificationItem instanceof \StructType\PartCertificationType) {
                throw new \InvalidArgumentException(sprintf('The VendorCertification property can only contain items of \StructType\PartCertificationType, "%s" given', is_object($aftermarketInfoTypeVendorCertificationItem) ? get_class($aftermarketInfoTypeVendorCertificationItem) : gettype($aftermarketInfoTypeVendorCertificationItem)), __LINE__);
            }
        }
        $this->VendorCertification = $vendorCertification;
        return $this;
    }
    /**
     * Add item to VendorCertification value
     * @throws \InvalidArgumentException
     * @param \StructType\PartCertificationType $item
     * @return \StructType\AftermarketInfoType
     */
    public function addToVendorCertification(\StructType\PartCertificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartCertificationType) {
            throw new \InvalidArgumentException(sprintf('The VendorCertification property can only contain items of \StructType\PartCertificationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorCertification[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AftermarketInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
