<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1 | 1
     * @var string
     */
    public $City;
    /**
     * The StateProvince
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - documentation: [AL] : [Alabama] [AK] : [Alaska] [AS] : [American Samoa] [AZ] : [Arizona] [AR] : [Arkansas] [CA] : [California] [CO] : [Colorado] [CT] : [Connecticut] [DE] : [Delaware] [DC] : [District Of Columbia] [FM] : [Federated States Of
     * Micronesia] [FL] : [Florida] [GA] : [Georgia] [GU] : [Guam] [HI] : [Hawaii] [ID] : [Idaho] [IL] : [Illinois] [IN] : [Indiana] [IA] : [Iowa] [KS] : [Kansas] [KY] : [Kentucky] [LA] : [Louisiana] [ME] : [Maine] [MH] : [Marshall Islands] [MD] :
     * [Maryland] [MA] : [Massachusetts] [MI] : [Michigan] [MN] : [Minnesota] [MS] : [Mississippi] [MO] : [Missouri] [MT] : [Montana] [NE] : [Nebraska] [NV] : [Nevada] [NH] : [New Hampshire] [NJ] : [New Jersey] [NM] : [New Mexico] [NY] : [New York] [NC] :
     * [North Carolina] [ND] : [North Dakota] [MP] : [Northern Mariana Islands] [OH] : [Ohio] [OK] : [Oklahoma] [OR] : [Oregon] [PW] : [Palau] [PA] : [Pennsylvania] [PR] : [Puerto Rico] [RI] : [Rhode Island] [SC] : [South Carolina] [SD] : [South Dakota]
     * [TN] : [Tennessee] [TX] : [Texas] [UT] : [Utah] [VT] : [Vermont] [VI] : [Virgin Islands] [VA] : [Virginia] [WA] : [Washington] [WV] : [West Virginia] [WI] : [Wisconsin] [WY] : [Wyoming] [AA] : [Armed Forces Americas (except Canada)] [AE] : [Armed
     * Forces Africa Armed Forces Canada Armed Forces Europe Armed Forces Middle East] [AP] : [Armed Forces Pacific] [AB] : [Alberta] [BC] : [British Columbia] [MB] : [Manitoba] [NB] : [New Brunswick] [NL] : [Newfoundland and Labrador] [NS] : [Nova Scotia]
     * [NT] : [Northwest Territories] [NU] : [Nunavut] [ON] : [Ontario] [PE] : [Prince Edward Island] [QC] : [Quebec] [SK] : [Saskatchewan] [YT] : [Yukon Territory]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $StateProvince;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 1 | 1
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - documentation: [CA] : [Canada] [MX] : [Mexico] [PR] : [Puerto Rico] [US] : [United States of America]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setAddress1()
     * @uses AddressType::setAddress2()
     * @uses AddressType::setCity()
     * @uses AddressType::setStateProvince()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setCountryCode()
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $stateProvince
     * @param string $postalCode
     * @param string $countryCode
     */
    public function __construct($address1 = null, $address2 = null, $city = null, $stateProvince = null, $postalCode = null, $countryCode = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setStateProvince($stateProvince)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\AddressType
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address1) && strlen($address1) > 80) || (is_array($address1) && count($address1) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($address1) ? strlen($address1) : count($address1)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($address1) && strlen($address1) < 1) || (is_array($address1) && count($address1) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\AddressType
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address2) && strlen($address2) > 80) || (is_array($address2) && count($address2) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($address2) ? strlen($address2) : count($address2)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($address2) && strlen($address2) < 1) || (is_array($address2) && count($address2) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 50) || (is_array($city) && count($city) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($city) && strlen($city) < 1) || (is_array($city) && count($city) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateProvince()
    {
        return isset($this->StateProvince) ? $this->StateProvince : null;
    }
    /**
     * Set StateProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateProvince
     * @return \StructType\AddressType
     */
    public function setStateProvince($stateProvince = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stateProvince) && strlen($stateProvince) > 80) || (is_array($stateProvince) && count($stateProvince) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($stateProvince) ? strlen($stateProvince) : count($stateProvince)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($stateProvince) && strlen($stateProvince) < 1) || (is_array($stateProvince) && count($stateProvince) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($stateProvince) && !preg_match('/[\\p{IsBasicLatin}]*/', $stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($stateProvince, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stateProvince) && !is_string($stateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateProvince)), __LINE__);
        }
        if (is_null($stateProvince) || (is_array($stateProvince) && empty($stateProvince))) {
            unset($this->StateProvince);
        } else {
            $this->StateProvince = $stateProvince;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalCode) && strlen($postalCode) > 15) || (is_array($postalCode) && count($postalCode) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($postalCode) ? strlen($postalCode) : count($postalCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postalCode) && strlen($postalCode) < 1) || (is_array($postalCode) && count($postalCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \StructType\AddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($countryCode) && strlen($countryCode) > 80) || (is_array($countryCode) && count($countryCode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($countryCode) ? strlen($countryCode) : count($countryCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($countryCode) && strlen($countryCode) < 1) || (is_array($countryCode) && count($countryCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($countryCode) && !preg_match('/[\\p{IsBasicLatin}]*/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($countryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
