<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleDescType StructType
 * @subpackage Structs
 */
class VehicleDescType extends AbstractStructBase
{
    /**
     * The ModelYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModelYear;
    /**
     * The MakeDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * - minLength: 1 | 1
     * @var string
     */
    public $MakeDesc;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1 | 1
     * @var string
     */
    public $ModelName;
    /**
     * The OdometerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OdometerInfoType
     */
    public $OdometerInfo;
    /**
     * Constructor method for VehicleDescType
     * @uses VehicleDescType::setModelYear()
     * @uses VehicleDescType::setMakeDesc()
     * @uses VehicleDescType::setModelName()
     * @uses VehicleDescType::setOdometerInfo()
     * @param string $modelYear
     * @param string $makeDesc
     * @param string $modelName
     * @param \StructType\OdometerInfoType $odometerInfo
     */
    public function __construct($modelYear = null, $makeDesc = null, $modelName = null, \StructType\OdometerInfoType $odometerInfo = null)
    {
        $this
            ->setModelYear($modelYear)
            ->setMakeDesc($makeDesc)
            ->setModelName($modelName)
            ->setOdometerInfo($odometerInfo);
    }
    /**
     * Get ModelYear value
     * @return string|null
     */
    public function getModelYear()
    {
        return $this->ModelYear;
    }
    /**
     * Set ModelYear value
     * @param string $modelYear
     * @return \StructType\VehicleDescType
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: string
        if (!is_null($modelYear) && !is_string($modelYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelYear)), __LINE__);
        }
        $this->ModelYear = $modelYear;
        return $this;
    }
    /**
     * Get MakeDesc value
     * @return string|null
     */
    public function getMakeDesc()
    {
        return $this->MakeDesc;
    }
    /**
     * Set MakeDesc value
     * @param string $makeDesc
     * @return \StructType\VehicleDescType
     */
    public function setMakeDesc($makeDesc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($makeDesc) && strlen($makeDesc) > 30) || (is_array($makeDesc) && count($makeDesc) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($makeDesc) ? strlen($makeDesc) : count($makeDesc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($makeDesc) && strlen($makeDesc) < 1) || (is_array($makeDesc) && count($makeDesc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($makeDesc) && !is_string($makeDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($makeDesc)), __LINE__);
        }
        $this->MakeDesc = $makeDesc;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \StructType\VehicleDescType
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($modelName) && strlen($modelName) > 50) || (is_array($modelName) && count($modelName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($modelName) ? strlen($modelName) : count($modelName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($modelName) && strlen($modelName) < 1) || (is_array($modelName) && count($modelName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelName)), __LINE__);
        }
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get OdometerInfo value
     * @return \StructType\OdometerInfoType|null
     */
    public function getOdometerInfo()
    {
        return $this->OdometerInfo;
    }
    /**
     * Set OdometerInfo value
     * @param \StructType\OdometerInfoType $odometerInfo
     * @return \StructType\VehicleDescType
     */
    public function setOdometerInfo(\StructType\OdometerInfoType $odometerInfo = null)
    {
        $this->OdometerInfo = $odometerInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleDescType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
