<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecycleInfoType StructType
 * @subpackage Structs
 */
class RecycleInfoType extends AbstractStructBase
{
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - minLength: 1
     * @var string
     */
    public $Grade;
    /**
     * The SourceVehicleInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleInfoType
     */
    public $SourceVehicleInfo;
    /**
     * The DaysInStock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxInclusive: 9999999999
     * - minInclusive: 0
     * @var int
     */
    public $DaysInStock;
    /**
     * The PartLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 1 | 1
     * @var string
     */
    public $PartLocation;
    /**
     * The PartCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 6
     * - minLength: 1 | 1
     * @var string
     */
    public $PartCategory;
    /**
     * The PartStore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1 | 1
     * @var string
     */
    public $PartStore;
    /**
     * Constructor method for RecycleInfoType
     * @uses RecycleInfoType::setGrade()
     * @uses RecycleInfoType::setSourceVehicleInfo()
     * @uses RecycleInfoType::setDaysInStock()
     * @uses RecycleInfoType::setPartLocation()
     * @uses RecycleInfoType::setPartCategory()
     * @uses RecycleInfoType::setPartStore()
     * @param string $grade
     * @param \StructType\VehicleInfoType $sourceVehicleInfo
     * @param int $daysInStock
     * @param string $partLocation
     * @param string $partCategory
     * @param string $partStore
     */
    public function __construct($grade = null, \StructType\VehicleInfoType $sourceVehicleInfo = null, $daysInStock = null, $partLocation = null, $partCategory = null, $partStore = null)
    {
        $this
            ->setGrade($grade)
            ->setSourceVehicleInfo($sourceVehicleInfo)
            ->setDaysInStock($daysInStock)
            ->setPartLocation($partLocation)
            ->setPartCategory($partCategory)
            ->setPartStore($partStore);
    }
    /**
     * Get Grade value
     * @return string|null
     */
    public function getGrade()
    {
        return $this->Grade;
    }
    /**
     * Set Grade value
     * @param string $grade
     * @return \StructType\RecycleInfoType
     */
    public function setGrade($grade = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($grade) && strlen($grade) < 1) || (is_array($grade) && count($grade) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($grade) && !is_string($grade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grade)), __LINE__);
        }
        $this->Grade = $grade;
        return $this;
    }
    /**
     * Get SourceVehicleInfo value
     * @return \StructType\VehicleInfoType|null
     */
    public function getSourceVehicleInfo()
    {
        return $this->SourceVehicleInfo;
    }
    /**
     * Set SourceVehicleInfo value
     * @param \StructType\VehicleInfoType $sourceVehicleInfo
     * @return \StructType\RecycleInfoType
     */
    public function setSourceVehicleInfo(\StructType\VehicleInfoType $sourceVehicleInfo = null)
    {
        $this->SourceVehicleInfo = $sourceVehicleInfo;
        return $this;
    }
    /**
     * Get DaysInStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDaysInStock()
    {
        return isset($this->DaysInStock) ? $this->DaysInStock : null;
    }
    /**
     * Set DaysInStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $daysInStock
     * @return \StructType\RecycleInfoType
     */
    public function setDaysInStock($daysInStock = null)
    {
        // validation for constraint: maxInclusive
        if ($daysInStock > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $daysInStock), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($daysInStock < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $daysInStock), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($daysInStock) && !is_numeric($daysInStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysInStock)), __LINE__);
        }
        if (is_null($daysInStock) || (is_array($daysInStock) && empty($daysInStock))) {
            unset($this->DaysInStock);
        } else {
            $this->DaysInStock = $daysInStock;
        }
        return $this;
    }
    /**
     * Get PartLocation value
     * @return string|null
     */
    public function getPartLocation()
    {
        return $this->PartLocation;
    }
    /**
     * Set PartLocation value
     * @param string $partLocation
     * @return \StructType\RecycleInfoType
     */
    public function setPartLocation($partLocation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partLocation) && strlen($partLocation) > 15) || (is_array($partLocation) && count($partLocation) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($partLocation) ? strlen($partLocation) : count($partLocation)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partLocation) && strlen($partLocation) < 1) || (is_array($partLocation) && count($partLocation) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partLocation) && !is_string($partLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partLocation)), __LINE__);
        }
        $this->PartLocation = $partLocation;
        return $this;
    }
    /**
     * Get PartCategory value
     * @return string|null
     */
    public function getPartCategory()
    {
        return $this->PartCategory;
    }
    /**
     * Set PartCategory value
     * @param string $partCategory
     * @return \StructType\RecycleInfoType
     */
    public function setPartCategory($partCategory = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partCategory) && strlen($partCategory) > 6) || (is_array($partCategory) && count($partCategory) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($partCategory) ? strlen($partCategory) : count($partCategory)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partCategory) && strlen($partCategory) < 1) || (is_array($partCategory) && count($partCategory) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partCategory) && !is_string($partCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partCategory)), __LINE__);
        }
        $this->PartCategory = $partCategory;
        return $this;
    }
    /**
     * Get PartStore value
     * @return string|null
     */
    public function getPartStore()
    {
        return $this->PartStore;
    }
    /**
     * Set PartStore value
     * @param string $partStore
     * @return \StructType\RecycleInfoType
     */
    public function setPartStore($partStore = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partStore) && strlen($partStore) > 50) || (is_array($partStore) && count($partStore) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($partStore) ? strlen($partStore) : count($partStore)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partStore) && strlen($partStore) < 1) || (is_array($partStore) && count($partStore) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partStore) && !is_string($partStore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partStore)), __LINE__);
        }
        $this->PartStore = $partStore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecycleInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
