<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuoteInfoType StructType
 * @subpackage Structs
 */
class QuoteInfoType extends AbstractStructBase
{
    /**
     * The QuoteRefNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 45
     * - minLength: 1 | 1
     * @var string
     */
    public $QuoteRefNum;
    /**
     * The QuoteDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $QuoteDateTime;
    /**
     * Constructor method for QuoteInfoType
     * @uses QuoteInfoType::setQuoteRefNum()
     * @uses QuoteInfoType::setQuoteDateTime()
     * @param string $quoteRefNum
     * @param string $quoteDateTime
     */
    public function __construct($quoteRefNum = null, $quoteDateTime = null)
    {
        $this
            ->setQuoteRefNum($quoteRefNum)
            ->setQuoteDateTime($quoteDateTime);
    }
    /**
     * Get QuoteRefNum value
     * @return string|null
     */
    public function getQuoteRefNum()
    {
        return $this->QuoteRefNum;
    }
    /**
     * Set QuoteRefNum value
     * @param string $quoteRefNum
     * @return \StructType\QuoteInfoType
     */
    public function setQuoteRefNum($quoteRefNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($quoteRefNum) && strlen($quoteRefNum) > 45) || (is_array($quoteRefNum) && count($quoteRefNum) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($quoteRefNum) ? strlen($quoteRefNum) : count($quoteRefNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($quoteRefNum) && strlen($quoteRefNum) < 1) || (is_array($quoteRefNum) && count($quoteRefNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($quoteRefNum) && !is_string($quoteRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quoteRefNum)), __LINE__);
        }
        $this->QuoteRefNum = $quoteRefNum;
        return $this;
    }
    /**
     * Get QuoteDateTime value
     * @return string|null
     */
    public function getQuoteDateTime()
    {
        return $this->QuoteDateTime;
    }
    /**
     * Set QuoteDateTime value
     * @param string $quoteDateTime
     * @return \StructType\QuoteInfoType
     */
    public function setQuoteDateTime($quoteDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($quoteDateTime) && !is_string($quoteDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quoteDateTime)), __LINE__);
        }
        $this->QuoteDateTime = $quoteDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuoteInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
