<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcurementPartType StructType
 * @subpackage Structs
 */
class ProcurementPartType extends AbstractStructBase
{
    /**
     * The ProcurementRefLineNum
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999
     * - minInclusive: 0
     * @var int
     */
    public $ProcurementRefLineNum;
    /**
     * The SelectedPart
     * @var \StructType\PartItemRequestInfoType
     */
    public $SelectedPart;
    /**
     * The NeedByDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NeedByDateTime;
    /**
     * The SupplierResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SupplierRsType[]
     */
    public $SupplierResponse;
    /**
     * Constructor method for ProcurementPartType
     * @uses ProcurementPartType::setProcurementRefLineNum()
     * @uses ProcurementPartType::setSelectedPart()
     * @uses ProcurementPartType::setNeedByDateTime()
     * @uses ProcurementPartType::setSupplierResponse()
     * @param int $procurementRefLineNum
     * @param \StructType\PartItemRequestInfoType $selectedPart
     * @param string $needByDateTime
     * @param \StructType\SupplierRsType[] $supplierResponse
     */
    public function __construct($procurementRefLineNum = null, \StructType\PartItemRequestInfoType $selectedPart = null, $needByDateTime = null, array $supplierResponse = array())
    {
        $this
            ->setProcurementRefLineNum($procurementRefLineNum)
            ->setSelectedPart($selectedPart)
            ->setNeedByDateTime($needByDateTime)
            ->setSupplierResponse($supplierResponse);
    }
    /**
     * Get ProcurementRefLineNum value
     * @return int|null
     */
    public function getProcurementRefLineNum()
    {
        return $this->ProcurementRefLineNum;
    }
    /**
     * Set ProcurementRefLineNum value
     * @param int $procurementRefLineNum
     * @return \StructType\ProcurementPartType
     */
    public function setProcurementRefLineNum($procurementRefLineNum = null)
    {
        // validation for constraint: maxInclusive
        if ($procurementRefLineNum > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999, "%s" given', $procurementRefLineNum), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($procurementRefLineNum < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $procurementRefLineNum), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($procurementRefLineNum) && !is_numeric($procurementRefLineNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($procurementRefLineNum)), __LINE__);
        }
        $this->ProcurementRefLineNum = $procurementRefLineNum;
        return $this;
    }
    /**
     * Get SelectedPart value
     * @return \StructType\PartItemRequestInfoType|null
     */
    public function getSelectedPart()
    {
        return $this->SelectedPart;
    }
    /**
     * Set SelectedPart value
     * @param \StructType\PartItemRequestInfoType $selectedPart
     * @return \StructType\ProcurementPartType
     */
    public function setSelectedPart(\StructType\PartItemRequestInfoType $selectedPart = null)
    {
        $this->SelectedPart = $selectedPart;
        return $this;
    }
    /**
     * Get NeedByDateTime value
     * @return string|null
     */
    public function getNeedByDateTime()
    {
        return $this->NeedByDateTime;
    }
    /**
     * Set NeedByDateTime value
     * @param string $needByDateTime
     * @return \StructType\ProcurementPartType
     */
    public function setNeedByDateTime($needByDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($needByDateTime) && !is_string($needByDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($needByDateTime)), __LINE__);
        }
        $this->NeedByDateTime = $needByDateTime;
        return $this;
    }
    /**
     * Get SupplierResponse value
     * @return \StructType\SupplierRsType[]|null
     */
    public function getSupplierResponse()
    {
        return $this->SupplierResponse;
    }
    /**
     * Set SupplierResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRsType[] $supplierResponse
     * @return \StructType\ProcurementPartType
     */
    public function setSupplierResponse(array $supplierResponse = array())
    {
        foreach ($supplierResponse as $procurementPartTypeSupplierResponseItem) {
            // validation for constraint: itemType
            if (!$procurementPartTypeSupplierResponseItem instanceof \StructType\SupplierRsType) {
                throw new \InvalidArgumentException(sprintf('The SupplierResponse property can only contain items of \StructType\SupplierRsType, "%s" given', is_object($procurementPartTypeSupplierResponseItem) ? get_class($procurementPartTypeSupplierResponseItem) : gettype($procurementPartTypeSupplierResponseItem)), __LINE__);
            }
        }
        $this->SupplierResponse = $supplierResponse;
        return $this;
    }
    /**
     * Add item to SupplierResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierRsType $item
     * @return \StructType\ProcurementPartType
     */
    public function addToSupplierResponse(\StructType\SupplierRsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierRsType) {
            throw new \InvalidArgumentException(sprintf('The SupplierResponse property can only contain items of \StructType\SupplierRsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SupplierResponse[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcurementPartType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
