<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcurementPartListType StructType
 * @subpackage Structs
 */
class ProcurementPartListType extends AbstractStructBase
{
    /**
     * The ProcurementPart
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProcurementPartType[]
     */
    public $ProcurementPart;
    /**
     * Constructor method for ProcurementPartListType
     * @uses ProcurementPartListType::setProcurementPart()
     * @param \StructType\ProcurementPartType[] $procurementPart
     */
    public function __construct(array $procurementPart = array())
    {
        $this
            ->setProcurementPart($procurementPart);
    }
    /**
     * Get ProcurementPart value
     * @return \StructType\ProcurementPartType[]|null
     */
    public function getProcurementPart()
    {
        return $this->ProcurementPart;
    }
    /**
     * Set ProcurementPart value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcurementPartType[] $procurementPart
     * @return \StructType\ProcurementPartListType
     */
    public function setProcurementPart(array $procurementPart = array())
    {
        foreach ($procurementPart as $procurementPartListTypeProcurementPartItem) {
            // validation for constraint: itemType
            if (!$procurementPartListTypeProcurementPartItem instanceof \StructType\ProcurementPartType) {
                throw new \InvalidArgumentException(sprintf('The ProcurementPart property can only contain items of \StructType\ProcurementPartType, "%s" given', is_object($procurementPartListTypeProcurementPartItem) ? get_class($procurementPartListTypeProcurementPartItem) : gettype($procurementPartListTypeProcurementPartItem)), __LINE__);
            }
        }
        $this->ProcurementPart = $procurementPart;
        return $this;
    }
    /**
     * Add item to ProcurementPart value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcurementPartType $item
     * @return \StructType\ProcurementPartListType
     */
    public function addToProcurementPart(\StructType\ProcurementPartType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProcurementPartType) {
            throw new \InvalidArgumentException(sprintf('The ProcurementPart property can only contain items of \StructType\ProcurementPartType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProcurementPart[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcurementPartListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
