<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcurementInfoType StructType
 * @subpackage Structs
 */
class ProcurementInfoType extends AbstractStructBase
{
    /**
     * The BMSObject
     * @var \StructType\BMSObjectType
     */
    public $BMSObject;
    /**
     * The ProcurementRefInfo
     * @var \StructType\ProcurementRefInfoType
     */
    public $ProcurementRefInfo;
    /**
     * The ProcurementPartList
     * @var \StructType\ProcurementPartListType
     */
    public $ProcurementPartList;
    /**
     * Constructor method for ProcurementInfoType
     * @uses ProcurementInfoType::setBMSObject()
     * @uses ProcurementInfoType::setProcurementRefInfo()
     * @uses ProcurementInfoType::setProcurementPartList()
     * @param \StructType\BMSObjectType $bMSObject
     * @param \StructType\ProcurementRefInfoType $procurementRefInfo
     * @param \StructType\ProcurementPartListType $procurementPartList
     */
    public function __construct(\StructType\BMSObjectType $bMSObject = null, \StructType\ProcurementRefInfoType $procurementRefInfo = null, \StructType\ProcurementPartListType $procurementPartList = null)
    {
        $this
            ->setBMSObject($bMSObject)
            ->setProcurementRefInfo($procurementRefInfo)
            ->setProcurementPartList($procurementPartList);
    }
    /**
     * Get BMSObject value
     * @return \StructType\BMSObjectType|null
     */
    public function getBMSObject()
    {
        return $this->BMSObject;
    }
    /**
     * Set BMSObject value
     * @param \StructType\BMSObjectType $bMSObject
     * @return \StructType\ProcurementInfoType
     */
    public function setBMSObject(\StructType\BMSObjectType $bMSObject = null)
    {
        $this->BMSObject = $bMSObject;
        return $this;
    }
    /**
     * Get ProcurementRefInfo value
     * @return \StructType\ProcurementRefInfoType|null
     */
    public function getProcurementRefInfo()
    {
        return $this->ProcurementRefInfo;
    }
    /**
     * Set ProcurementRefInfo value
     * @param \StructType\ProcurementRefInfoType $procurementRefInfo
     * @return \StructType\ProcurementInfoType
     */
    public function setProcurementRefInfo(\StructType\ProcurementRefInfoType $procurementRefInfo = null)
    {
        $this->ProcurementRefInfo = $procurementRefInfo;
        return $this;
    }
    /**
     * Get ProcurementPartList value
     * @return \StructType\ProcurementPartListType|null
     */
    public function getProcurementPartList()
    {
        return $this->ProcurementPartList;
    }
    /**
     * Set ProcurementPartList value
     * @param \StructType\ProcurementPartListType $procurementPartList
     * @return \StructType\ProcurementInfoType
     */
    public function setProcurementPartList(\StructType\ProcurementPartListType $procurementPartList = null)
    {
        $this->ProcurementPartList = $procurementPartList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcurementInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
