<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartCertificationType StructType
 * @subpackage Structs
 */
class PartCertificationType extends AbstractStructBase
{
    /**
     * The CertificationType
     * Meta informations extracted from the WSDL
     * - documentation: [A] : [ARA Part Disclosure] [B] : [Car-Part Bronze] [C] : [Certified Automotive Parts Association (CAPA)] [G] : [ARA Gold Seal] [I] : [Insurance Quality] [M] : [Manufacturer's Qualification and Validation Program (MQVP) - Note This
     * Company no longer exists] [N] : [NSF International - Collision Replacement Parts Certification Program] [P] : [ARA Pro - Airbag] [R] : [ARA CAR] [S] : [Car-Part Silver] [T] : [Car-Part Gold] [U] : [URG 8000]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $CertificationType;
    /**
     * The CertifiedOnlyInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CertifiedOnlyInd;
    /**
     * The CertifiedPreferredInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CertifiedPreferredInd;
    /**
     * The CertificationNum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1 | 1
     * @var string
     */
    public $CertificationNum;
    /**
     * Constructor method for PartCertificationType
     * @uses PartCertificationType::setCertificationType()
     * @uses PartCertificationType::setCertifiedOnlyInd()
     * @uses PartCertificationType::setCertifiedPreferredInd()
     * @uses PartCertificationType::setCertificationNum()
     * @param string $certificationType
     * @param bool $certifiedOnlyInd
     * @param bool $certifiedPreferredInd
     * @param string $certificationNum
     */
    public function __construct($certificationType = null, $certifiedOnlyInd = null, $certifiedPreferredInd = null, $certificationNum = null)
    {
        $this
            ->setCertificationType($certificationType)
            ->setCertifiedOnlyInd($certifiedOnlyInd)
            ->setCertifiedPreferredInd($certifiedPreferredInd)
            ->setCertificationNum($certificationNum);
    }
    /**
     * Get CertificationType value
     * @return string|null
     */
    public function getCertificationType()
    {
        return $this->CertificationType;
    }
    /**
     * Set CertificationType value
     * @param string $certificationType
     * @return \StructType\PartCertificationType
     */
    public function setCertificationType($certificationType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($certificationType) && strlen($certificationType) > 80) || (is_array($certificationType) && count($certificationType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($certificationType) ? strlen($certificationType) : count($certificationType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($certificationType) && strlen($certificationType) < 1) || (is_array($certificationType) && count($certificationType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($certificationType) && !preg_match('/[\\p{IsBasicLatin}]*/', $certificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($certificationType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($certificationType) && !is_string($certificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certificationType)), __LINE__);
        }
        $this->CertificationType = $certificationType;
        return $this;
    }
    /**
     * Get CertifiedOnlyInd value
     * @return bool|null
     */
    public function getCertifiedOnlyInd()
    {
        return $this->CertifiedOnlyInd;
    }
    /**
     * Set CertifiedOnlyInd value
     * @param bool $certifiedOnlyInd
     * @return \StructType\PartCertificationType
     */
    public function setCertifiedOnlyInd($certifiedOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifiedOnlyInd) && !is_bool($certifiedOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($certifiedOnlyInd)), __LINE__);
        }
        $this->CertifiedOnlyInd = $certifiedOnlyInd;
        return $this;
    }
    /**
     * Get CertifiedPreferredInd value
     * @return bool|null
     */
    public function getCertifiedPreferredInd()
    {
        return $this->CertifiedPreferredInd;
    }
    /**
     * Set CertifiedPreferredInd value
     * @param bool $certifiedPreferredInd
     * @return \StructType\PartCertificationType
     */
    public function setCertifiedPreferredInd($certifiedPreferredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifiedPreferredInd) && !is_bool($certifiedPreferredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($certifiedPreferredInd)), __LINE__);
        }
        $this->CertifiedPreferredInd = $certifiedPreferredInd;
        return $this;
    }
    /**
     * Get CertificationNum value
     * @return string|null
     */
    public function getCertificationNum()
    {
        return $this->CertificationNum;
    }
    /**
     * Set CertificationNum value
     * @param string $certificationNum
     * @return \StructType\PartCertificationType
     */
    public function setCertificationNum($certificationNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($certificationNum) && strlen($certificationNum) > 50) || (is_array($certificationNum) && count($certificationNum) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($certificationNum) ? strlen($certificationNum) : count($certificationNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($certificationNum) && strlen($certificationNum) < 1) || (is_array($certificationNum) && count($certificationNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($certificationNum) && !is_string($certificationNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certificationNum)), __LINE__);
        }
        $this->CertificationNum = $certificationNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartCertificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
