<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrgInfoType StructType
 * @subpackage Structs
 */
class OrgInfoType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string
     */
    public $CompanyName;
    /**
     * The IDInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\IDInfoType[]
     */
    public $IDInfo;
    /**
     * Constructor method for OrgInfoType
     * @uses OrgInfoType::setCompanyName()
     * @uses OrgInfoType::setIDInfo()
     * @param string $companyName
     * @param \StructType\IDInfoType[] $iDInfo
     */
    public function __construct($companyName = null, array $iDInfo = array())
    {
        $this
            ->setCompanyName($companyName)
            ->setIDInfo($iDInfo);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\OrgInfoType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($companyName) && strlen($companyName) > 80) || (is_array($companyName) && count($companyName) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($companyName) ? strlen($companyName) : count($companyName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($companyName) && strlen($companyName) < 1) || (is_array($companyName) && count($companyName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get IDInfo value
     * @return \StructType\IDInfoType[]|null
     */
    public function getIDInfo()
    {
        return $this->IDInfo;
    }
    /**
     * Set IDInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IDInfoType[] $iDInfo
     * @return \StructType\OrgInfoType
     */
    public function setIDInfo(array $iDInfo = array())
    {
        foreach ($iDInfo as $orgInfoTypeIDInfoItem) {
            // validation for constraint: itemType
            if (!$orgInfoTypeIDInfoItem instanceof \StructType\IDInfoType) {
                throw new \InvalidArgumentException(sprintf('The IDInfo property can only contain items of \StructType\IDInfoType, "%s" given', is_object($orgInfoTypeIDInfoItem) ? get_class($orgInfoTypeIDInfoItem) : gettype($orgInfoTypeIDInfoItem)), __LINE__);
            }
        }
        $this->IDInfo = $iDInfo;
        return $this;
    }
    /**
     * Add item to IDInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IDInfoType $item
     * @return \StructType\OrgInfoType
     */
    public function addToIDInfo(\StructType\IDInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IDInfoType) {
            throw new \InvalidArgumentException(sprintf('The IDInfo property can only contain items of \StructType\IDInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IDInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrgInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
