<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineNoteInfoType StructType
 * @subpackage Structs
 */
class LineNoteInfoType extends AbstractStructBase
{
    /**
     * The LineNoteMemo
     * Meta informations extracted from the WSDL
     * - minLength: 1
     * @var string
     */
    public $LineNoteMemo;
    /**
     * The AuthoredBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $AuthoredBy;
    /**
     * Constructor method for LineNoteInfoType
     * @uses LineNoteInfoType::setLineNoteMemo()
     * @uses LineNoteInfoType::setAuthoredBy()
     * @param string $lineNoteMemo
     * @param \StructType\PersonNameType $authoredBy
     */
    public function __construct($lineNoteMemo = null, \StructType\PersonNameType $authoredBy = null)
    {
        $this
            ->setLineNoteMemo($lineNoteMemo)
            ->setAuthoredBy($authoredBy);
    }
    /**
     * Get LineNoteMemo value
     * @return string|null
     */
    public function getLineNoteMemo()
    {
        return $this->LineNoteMemo;
    }
    /**
     * Set LineNoteMemo value
     * @param string $lineNoteMemo
     * @return \StructType\LineNoteInfoType
     */
    public function setLineNoteMemo($lineNoteMemo = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($lineNoteMemo) && strlen($lineNoteMemo) < 1) || (is_array($lineNoteMemo) && count($lineNoteMemo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lineNoteMemo) && !is_string($lineNoteMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineNoteMemo)), __LINE__);
        }
        $this->LineNoteMemo = $lineNoteMemo;
        return $this;
    }
    /**
     * Get AuthoredBy value
     * @return \StructType\PersonNameType|null
     */
    public function getAuthoredBy()
    {
        return $this->AuthoredBy;
    }
    /**
     * Set AuthoredBy value
     * @param \StructType\PersonNameType $authoredBy
     * @return \StructType\LineNoteInfoType
     */
    public function setAuthoredBy(\StructType\PersonNameType $authoredBy = null)
    {
        $this->AuthoredBy = $authoredBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineNoteInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
