<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDInfoType StructType
 * @subpackage Structs
 */
class IDInfoType extends AbstractStructBase
{
    /**
     * The IDQualifierCode
     * Meta informations extracted from the WSDL
     * - documentation: [Account Number] : [Normally the owner's loan account number] [Agent Code] : [Code assigned to agent] [Agent Number] : [Number of the insurance agent] [AL] : [Appraiser's License Number] [Assignment Number] : [Unique assignment
     * number intended to identify an assignment] [Authorization Code] : [Authorization code] [BAR] : [Bureau of Automotive Repair Number] [CompanyID] : [Company Identification] [Control Number] : [Assigned by the system for entry of claim, could be a
     * combination of items] [Coupon Number] : [Purchase order parallel term for some companies] [Customer Number] : [Number assigned to a customer, can be used for survey messages] [District Code] : [Code assigned by the insurance company to the District]
     * [Drivers License Number] : [Drivers License Number] [Drivers License Number Country] : [Drivers License Number Country] [Drivers License Number State] : [Drivers License Number State] [DUNS] : [D-U-N-S Number, Dun & Bradstreet] [Employee ID] : [The
     * identifier for the employee] [EPA] : [Environmental Protection Agency Number] [Evaluation ID] : [Evaluation Identifier] [FI] : [Federal Taxpayer Identification] [FO] : [Field Office Identification] [Internal Vendor ID] : [Intenally generated ID and
     * used to share XML messages within an organziation.] [Lease Number] : [Vehicle's lease number] [NICB Company Code] : [NICB code for insurance company] [NMVTIS] : [A NMVTIS Assigned Number] [Office ID] : [Office Identification] [PartnerID] : [Trading
     * Partner Identification] [Repair Facility ID] : [Identifier for the Repair Facility] [Repair Order Number] : [Repair order number from the repair facility] [RI] : [Representative Identification] [Social Security Number] : [Social Security Number of
     * person] [State Tax Exempt] : [State Tax Exempt Number] [Stock Number] : [Stock number for fleet vehicle, Or Stock or Lot number for Salvage Location] [TI] : [Taxpayer Identification] [TID] : [Supplier TID] [Token] : [Supplier Token] [US] : [Unique
     * Supplier Identification Number (USIN)] [User ID] : [Identifier of the user] [Vendor ID] : [Vendor ID] [WAGroupID] : [Work Assignment Group Identification] [Yard Location] : [Yard Location identifier]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $IDQualifierCode;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * - minLength: 1 | 1
     * @var string
     */
    public $IDNum;
    /**
     * Constructor method for IDInfoType
     * @uses IDInfoType::setIDQualifierCode()
     * @uses IDInfoType::setIDNum()
     * @param string $iDQualifierCode
     * @param string $iDNum
     */
    public function __construct($iDQualifierCode = null, $iDNum = null)
    {
        $this
            ->setIDQualifierCode($iDQualifierCode)
            ->setIDNum($iDNum);
    }
    /**
     * Get IDQualifierCode value
     * @return string|null
     */
    public function getIDQualifierCode()
    {
        return $this->IDQualifierCode;
    }
    /**
     * Set IDQualifierCode value
     * @param string $iDQualifierCode
     * @return \StructType\IDInfoType
     */
    public function setIDQualifierCode($iDQualifierCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDQualifierCode) && strlen($iDQualifierCode) > 80) || (is_array($iDQualifierCode) && count($iDQualifierCode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($iDQualifierCode) ? strlen($iDQualifierCode) : count($iDQualifierCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDQualifierCode) && strlen($iDQualifierCode) < 1) || (is_array($iDQualifierCode) && count($iDQualifierCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iDQualifierCode) && !preg_match('/[\\p{IsBasicLatin}]*/', $iDQualifierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($iDQualifierCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDQualifierCode) && !is_string($iDQualifierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDQualifierCode)), __LINE__);
        }
        $this->IDQualifierCode = $iDQualifierCode;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \StructType\IDInfoType
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 80) || (is_array($iDNum) && count($iDNum) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
