<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericPartyType StructType
 * @subpackage Structs
 */
class GenericPartyType extends AbstractStructBase
{
    /**
     * The Party
     * @var \StructType\PartyType
     */
    public $Party;
    /**
     * The OtherParty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OtherPartyType[]
     */
    public $OtherParty;
    /**
     * Constructor method for GenericPartyType
     * @uses GenericPartyType::setParty()
     * @uses GenericPartyType::setOtherParty()
     * @param \StructType\PartyType $party
     * @param \StructType\OtherPartyType[] $otherParty
     */
    public function __construct(\StructType\PartyType $party = null, array $otherParty = array())
    {
        $this
            ->setParty($party)
            ->setOtherParty($otherParty);
    }
    /**
     * Get Party value
     * @return \StructType\PartyType|null
     */
    public function getParty()
    {
        return $this->Party;
    }
    /**
     * Set Party value
     * @param \StructType\PartyType $party
     * @return \StructType\GenericPartyType
     */
    public function setParty(\StructType\PartyType $party = null)
    {
        $this->Party = $party;
        return $this;
    }
    /**
     * Get OtherParty value
     * @return \StructType\OtherPartyType[]|null
     */
    public function getOtherParty()
    {
        return $this->OtherParty;
    }
    /**
     * Set OtherParty value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherPartyType[] $otherParty
     * @return \StructType\GenericPartyType
     */
    public function setOtherParty(array $otherParty = array())
    {
        foreach ($otherParty as $genericPartyTypeOtherPartyItem) {
            // validation for constraint: itemType
            if (!$genericPartyTypeOtherPartyItem instanceof \StructType\OtherPartyType) {
                throw new \InvalidArgumentException(sprintf('The OtherParty property can only contain items of \StructType\OtherPartyType, "%s" given', is_object($genericPartyTypeOtherPartyItem) ? get_class($genericPartyTypeOtherPartyItem) : gettype($genericPartyTypeOtherPartyItem)), __LINE__);
            }
        }
        $this->OtherParty = $otherParty;
        return $this;
    }
    /**
     * Add item to OtherParty value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherPartyType $item
     * @return \StructType\GenericPartyType
     */
    public function addToOtherParty(\StructType\OtherPartyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OtherPartyType) {
            throw new \InvalidArgumentException(sprintf('The OtherParty property can only contain items of \StructType\OtherPartyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OtherParty[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericPartyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
