<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BMSObjectType StructType
 * @subpackage Structs
 */
class BMSObjectType extends AbstractStructBase
{
    /**
     * The UUID
     * Meta informations extracted from the WSDL
     * - maxLength: 36
     * - minLength: 36 | 1
     * - pattern: ([0-9]|[a-f]|[A-F]){8}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){12} | [\p{IsBasicLatin}]*
     * @var string
     */
    public $UUID;
    /**
     * The RefUUID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 36
     * - minLength: 36 | 1
     * - pattern: ([0-9]|[a-f]|[A-F]){8}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){4}-([0-9]|[a-f]|[A-F]){12} | [\p{IsBasicLatin}]*
     * @var string
     */
    public $RefUUID;
    /**
     * Constructor method for BMSObjectType
     * @uses BMSObjectType::setUUID()
     * @uses BMSObjectType::setRefUUID()
     * @param string $uUID
     * @param string $refUUID
     */
    public function __construct($uUID = null, $refUUID = null)
    {
        $this
            ->setUUID($uUID)
            ->setRefUUID($refUUID);
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\BMSObjectType
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uUID) && strlen($uUID) > 36) || (is_array($uUID) && count($uUID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($uUID) ? strlen($uUID) : count($uUID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uUID) && strlen($uUID) < 1) || (is_array($uUID) && count($uUID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($uUID) && !preg_match('//', $uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "Array", "%s" given', var_export($uUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get RefUUID value
     * @return string|null
     */
    public function getRefUUID()
    {
        return $this->RefUUID;
    }
    /**
     * Set RefUUID value
     * @param string $refUUID
     * @return \StructType\BMSObjectType
     */
    public function setRefUUID($refUUID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($refUUID) && strlen($refUUID) > 36) || (is_array($refUUID) && count($refUUID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($refUUID) ? strlen($refUUID) : count($refUUID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($refUUID) && strlen($refUUID) < 1) || (is_array($refUUID) && count($refUUID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($refUUID) && !preg_match('//', $refUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "Array", "%s" given', var_export($refUUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($refUUID) && !is_string($refUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refUUID)), __LINE__);
        }
        $this->RefUUID = $refUUID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BMSObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
