<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationStatusType StructType
 * @subpackage Structs
 */
class ApplicationStatusType extends AbstractStructBase
{
    /**
     * The ApplicationStatusCode
     * Meta informations extracted from the WSDL
     * - documentation: [Accept] : [Message was received successfully by application] [Partial] : [Message was received but was incomplete or not as expected] [Reject] : [Message could not be received by application]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $ApplicationStatusCode;
    /**
     * The ApplicationError
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ApplicationError[]
     */
    public $ApplicationError;
    /**
     * Constructor method for ApplicationStatusType
     * @uses ApplicationStatusType::setApplicationStatusCode()
     * @uses ApplicationStatusType::setApplicationError()
     * @param string $applicationStatusCode
     * @param \StructType\ApplicationError[] $applicationError
     */
    public function __construct($applicationStatusCode = null, array $applicationError = array())
    {
        $this
            ->setApplicationStatusCode($applicationStatusCode)
            ->setApplicationError($applicationError);
    }
    /**
     * Get ApplicationStatusCode value
     * @return string|null
     */
    public function getApplicationStatusCode()
    {
        return $this->ApplicationStatusCode;
    }
    /**
     * Set ApplicationStatusCode value
     * @param string $applicationStatusCode
     * @return \StructType\ApplicationStatusType
     */
    public function setApplicationStatusCode($applicationStatusCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($applicationStatusCode) && strlen($applicationStatusCode) > 80) || (is_array($applicationStatusCode) && count($applicationStatusCode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($applicationStatusCode) ? strlen($applicationStatusCode) : count($applicationStatusCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($applicationStatusCode) && strlen($applicationStatusCode) < 1) || (is_array($applicationStatusCode) && count($applicationStatusCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($applicationStatusCode) && !preg_match('/[\\p{IsBasicLatin}]*/', $applicationStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($applicationStatusCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applicationStatusCode) && !is_string($applicationStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationStatusCode)), __LINE__);
        }
        $this->ApplicationStatusCode = $applicationStatusCode;
        return $this;
    }
    /**
     * Get ApplicationError value
     * @return \StructType\ApplicationError[]|null
     */
    public function getApplicationError()
    {
        return $this->ApplicationError;
    }
    /**
     * Set ApplicationError value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicationError[] $applicationError
     * @return \StructType\ApplicationStatusType
     */
    public function setApplicationError(array $applicationError = array())
    {
        foreach ($applicationError as $applicationStatusTypeApplicationErrorItem) {
            // validation for constraint: itemType
            if (!$applicationStatusTypeApplicationErrorItem instanceof \StructType\ApplicationError) {
                throw new \InvalidArgumentException(sprintf('The ApplicationError property can only contain items of \StructType\ApplicationError, "%s" given', is_object($applicationStatusTypeApplicationErrorItem) ? get_class($applicationStatusTypeApplicationErrorItem) : gettype($applicationStatusTypeApplicationErrorItem)), __LINE__);
            }
        }
        $this->ApplicationError = $applicationError;
        return $this;
    }
    /**
     * Add item to ApplicationError value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicationError $item
     * @return \StructType\ApplicationStatusType
     */
    public function addToApplicationError(\StructType\ApplicationError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApplicationError) {
            throw new \InvalidArgumentException(sprintf('The ApplicationError property can only contain items of \StructType\ApplicationError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ApplicationError[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApplicationStatusType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
