<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationError StructType
 * @subpackage Structs
 */
class ApplicationError extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: [004] : [Unexpected Code Value] [006] : [Duplicate] [007] : [Missing Data] [008] : [Invalid Code Value] [011] : [Not Matching] [848] : [Incorrect Data] [88901] : [File received] [101110] : [User information not available] [101111] :
     * [Claim Number format is incorrect] [101112] : [Delete request submitted but the item the delete refers to does not exist] [101113] : [Unknown ID] [101114] : [Unsupported delete request] [101116] : [Implied delete performed] [101130] : [Unknown Error
     * Occurred] [159815] : [Evaluation ID in use by another Claim Number] [159816] : [Evaluation ID does not exist]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $ErrorCode;
    /**
     * The Severity
     * Meta informations extracted from the WSDL
     * - documentation: [Error] : [Message was declined] [Info] : [Message was accepted and additional information may be available.] [Warn] : [Message was accepted; however all of information may not be available.]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $Severity;
    /**
     * The ErrorDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1 | 1
     * @var string
     */
    public $ErrorDesc;
    /**
     * Constructor method for ApplicationError
     * @uses ApplicationError::setErrorCode()
     * @uses ApplicationError::setSeverity()
     * @uses ApplicationError::setErrorDesc()
     * @param string $errorCode
     * @param string $severity
     * @param string $errorDesc
     */
    public function __construct($errorCode = null, $severity = null, $errorDesc = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setSeverity($severity)
            ->setErrorDesc($errorDesc);
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\ApplicationError
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($errorCode) && strlen($errorCode) > 80) || (is_array($errorCode) && count($errorCode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($errorCode) ? strlen($errorCode) : count($errorCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($errorCode) && strlen($errorCode) < 1) || (is_array($errorCode) && count($errorCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($errorCode) && !preg_match('/[\\p{IsBasicLatin}]*/', $errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($errorCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \StructType\ApplicationError
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($severity) && strlen($severity) > 80) || (is_array($severity) && count($severity) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($severity) ? strlen($severity) : count($severity)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($severity) && strlen($severity) < 1) || (is_array($severity) && count($severity) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($severity) && !preg_match('/[\\p{IsBasicLatin}]*/', $severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($severity, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get ErrorDesc value
     * @return string|null
     */
    public function getErrorDesc()
    {
        return $this->ErrorDesc;
    }
    /**
     * Set ErrorDesc value
     * @param string $errorDesc
     * @return \StructType\ApplicationError
     */
    public function setErrorDesc($errorDesc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($errorDesc) && strlen($errorDesc) > 255) || (is_array($errorDesc) && count($errorDesc) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($errorDesc) ? strlen($errorDesc) : count($errorDesc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($errorDesc) && strlen($errorDesc) < 1) || (is_array($errorDesc) && count($errorDesc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($errorDesc) && !is_string($errorDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorDesc)), __LINE__);
        }
        $this->ErrorDesc = $errorDesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApplicationError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
