<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarrantyInfoType StructType
 * @subpackage Structs
 */
class WarrantyInfoType extends AbstractStructBase
{
    /**
     * The TermsAndConditions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - minLength: 1
     * @var string
     */
    public $TermsAndConditions;
    /**
     * Constructor method for WarrantyInfoType
     * @uses WarrantyInfoType::setTermsAndConditions()
     * @param string $termsAndConditions
     */
    public function __construct($termsAndConditions = null)
    {
        $this
            ->setTermsAndConditions($termsAndConditions);
    }
    /**
     * Get TermsAndConditions value
     * @return string|null
     */
    public function getTermsAndConditions()
    {
        return $this->TermsAndConditions;
    }
    /**
     * Set TermsAndConditions value
     * @param string $termsAndConditions
     * @return \StructType\WarrantyInfoType
     */
    public function setTermsAndConditions($termsAndConditions = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($termsAndConditions) && strlen($termsAndConditions) < 1) || (is_array($termsAndConditions) && count($termsAndConditions) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($termsAndConditions) && !is_string($termsAndConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($termsAndConditions)), __LINE__);
        }
        $this->TermsAndConditions = $termsAndConditions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarrantyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
