<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotedPartType StructType
 * @subpackage Structs
 */
class QuotedPartType extends AbstractStructBase
{
    /**
     * The BMSObject
     * @var \StructType\BMSObjectType
     */
    public $BMSObject;
    /**
     * The SupplierResponseCode
     * Meta informations extracted from the WSDL
     * - documentation: [Alternative] : [Alternative] [AsRequested] : [As Requested] [Complication] : [Complication] [Related] : [Related]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The SupplierRefLineNum
     * Meta informations extracted from the WSDL
     * - maxInclusive: 9999999999
     * - minInclusive: 0
     * @var int
     */
    public $SupplierRefLineNum;
    /**
     * The PartNumInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PartNumInfoType[]
     */
    public $PartNumInfo;
    /**
     * The PartType
     * Meta informations extracted from the WSDL
     * - documentation: [AD] : [Adhesive Kit] [GA] : [Gasket] [GF] : [Glass Frame] [GL] : [Glass] [HW] : [Hardware (Clips, screws, etc)] [IM] : [Installation Materials] [LO] : [Labor Only] [MO] : [Mouldings] [OT] : [Other] [PAA] : [Parts - Aftermarket]
     * [PAC] : [Parts - Rechromed] [PAD] : [Parts - Reconditioned] [PAE] : [Parts - Existing] [PAG] : [Parts � Glass] [PAGN] : [Parts - New Non-OEM Glass] [PAL] : [Parts - Recycled] [PAM] : [Parts - Remanufactured] [PAN] : [Parts - New OEM] [PAND] :
     * [Parts - New OEM discounted] [PAO] : [Parts - Other] [PAP] : [Parts - New, partial] [PAR] : [Parts - Re-cored] [PC] : [Parts - Core only] [RP] : [Repair] [TI] : [Tinting] [WE] : [Weatherstrip]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $PartType;
    /**
     * The PartDesc
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1 | 1
     * @var string
     */
    public $PartDesc;
    /**
     * The PriceInfo
     * @var \StructType\PriceInfoType
     */
    public $PriceInfo;
    /**
     * The AftermarketInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AftermarketInfoType
     */
    public $AftermarketInfo;
    /**
     * The RecycleInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecycleInfoType
     */
    public $RecycleInfo;
    /**
     * The QuoteInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\QuoteInfoType
     */
    public $QuoteInfo;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AvailabilityType
     */
    public $Availability;
    /**
     * The OrderToReceiptDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 9
     * - minInclusive: 0
     * @var int
     */
    public $OrderToReceiptDays;
    /**
     * The LineNoteInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LineNoteInfoType
     */
    public $LineNoteInfo;
    /**
     * The FileAttachment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileAttachmentType
     */
    public $FileAttachment;
    /**
     * The PartsWarrantyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarrantyInfoType[]
     */
    public $PartsWarrantyInfo;
    /**
     * Constructor method for QuotedPartType
     * @uses QuotedPartType::setBMSObject()
     * @uses QuotedPartType::setSupplierResponseCode()
     * @uses QuotedPartType::setSupplierRefLineNum()
     * @uses QuotedPartType::setPartNumInfo()
     * @uses QuotedPartType::setPartType()
     * @uses QuotedPartType::setPartDesc()
     * @uses QuotedPartType::setPriceInfo()
     * @uses QuotedPartType::setAftermarketInfo()
     * @uses QuotedPartType::setRecycleInfo()
     * @uses QuotedPartType::setQuoteInfo()
     * @uses QuotedPartType::setAvailability()
     * @uses QuotedPartType::setOrderToReceiptDays()
     * @uses QuotedPartType::setLineNoteInfo()
     * @uses QuotedPartType::setFileAttachment()
     * @uses QuotedPartType::setPartsWarrantyInfo()
     * @param \StructType\BMSObjectType $bMSObject
     * @param string $supplierResponseCode
     * @param int $supplierRefLineNum
     * @param \StructType\PartNumInfoType[] $partNumInfo
     * @param string $partType
     * @param string $partDesc
     * @param \StructType\PriceInfoType $priceInfo
     * @param \StructType\AftermarketInfoType $aftermarketInfo
     * @param \StructType\RecycleInfoType $recycleInfo
     * @param \StructType\QuoteInfoType $quoteInfo
     * @param \StructType\AvailabilityType $availability
     * @param int $orderToReceiptDays
     * @param \StructType\LineNoteInfoType $lineNoteInfo
     * @param \StructType\FileAttachmentType $fileAttachment
     * @param \StructType\WarrantyInfoType[] $partsWarrantyInfo
     */
    public function __construct(\StructType\BMSObjectType $bMSObject = null, $supplierResponseCode = null, $supplierRefLineNum = null, array $partNumInfo = array(), $partType = null, $partDesc = null, \StructType\PriceInfoType $priceInfo = null, \StructType\AftermarketInfoType $aftermarketInfo = null, \StructType\RecycleInfoType $recycleInfo = null, \StructType\QuoteInfoType $quoteInfo = null, \StructType\AvailabilityType $availability = null, $orderToReceiptDays = null, \StructType\LineNoteInfoType $lineNoteInfo = null, \StructType\FileAttachmentType $fileAttachment = null, array $partsWarrantyInfo = array())
    {
        $this
            ->setBMSObject($bMSObject)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setSupplierRefLineNum($supplierRefLineNum)
            ->setPartNumInfo($partNumInfo)
            ->setPartType($partType)
            ->setPartDesc($partDesc)
            ->setPriceInfo($priceInfo)
            ->setAftermarketInfo($aftermarketInfo)
            ->setRecycleInfo($recycleInfo)
            ->setQuoteInfo($quoteInfo)
            ->setAvailability($availability)
            ->setOrderToReceiptDays($orderToReceiptDays)
            ->setLineNoteInfo($lineNoteInfo)
            ->setFileAttachment($fileAttachment)
            ->setPartsWarrantyInfo($partsWarrantyInfo);
    }
    /**
     * Get BMSObject value
     * @return \StructType\BMSObjectType|null
     */
    public function getBMSObject()
    {
        return $this->BMSObject;
    }
    /**
     * Set BMSObject value
     * @param \StructType\BMSObjectType $bMSObject
     * @return \StructType\QuotedPartType
     */
    public function setBMSObject(\StructType\BMSObjectType $bMSObject = null)
    {
        $this->BMSObject = $bMSObject;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\QuotedPartType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($supplierResponseCode) && strlen($supplierResponseCode) > 80) || (is_array($supplierResponseCode) && count($supplierResponseCode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($supplierResponseCode) ? strlen($supplierResponseCode) : count($supplierResponseCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($supplierResponseCode) && strlen($supplierResponseCode) < 1) || (is_array($supplierResponseCode) && count($supplierResponseCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($supplierResponseCode) && !preg_match('/[\\p{IsBasicLatin}]*/', $supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($supplierResponseCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get SupplierRefLineNum value
     * @return int|null
     */
    public function getSupplierRefLineNum()
    {
        return $this->SupplierRefLineNum;
    }
    /**
     * Set SupplierRefLineNum value
     * @param int $supplierRefLineNum
     * @return \StructType\QuotedPartType
     */
    public function setSupplierRefLineNum($supplierRefLineNum = null)
    {
        // validation for constraint: maxInclusive
        if ($supplierRefLineNum > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $supplierRefLineNum), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($supplierRefLineNum < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $supplierRefLineNum), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($supplierRefLineNum) && !is_numeric($supplierRefLineNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierRefLineNum)), __LINE__);
        }
        $this->SupplierRefLineNum = $supplierRefLineNum;
        return $this;
    }
    /**
     * Get PartNumInfo value
     * @return \StructType\PartNumInfoType[]|null
     */
    public function getPartNumInfo()
    {
        return $this->PartNumInfo;
    }
    /**
     * Set PartNumInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PartNumInfoType[] $partNumInfo
     * @return \StructType\QuotedPartType
     */
    public function setPartNumInfo(array $partNumInfo = array())
    {
        foreach ($partNumInfo as $quotedPartTypePartNumInfoItem) {
            // validation for constraint: itemType
            if (!$quotedPartTypePartNumInfoItem instanceof \StructType\PartNumInfoType) {
                throw new \InvalidArgumentException(sprintf('The PartNumInfo property can only contain items of \StructType\PartNumInfoType, "%s" given', is_object($quotedPartTypePartNumInfoItem) ? get_class($quotedPartTypePartNumInfoItem) : gettype($quotedPartTypePartNumInfoItem)), __LINE__);
            }
        }
        $this->PartNumInfo = $partNumInfo;
        return $this;
    }
    /**
     * Add item to PartNumInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PartNumInfoType $item
     * @return \StructType\QuotedPartType
     */
    public function addToPartNumInfo(\StructType\PartNumInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartNumInfoType) {
            throw new \InvalidArgumentException(sprintf('The PartNumInfo property can only contain items of \StructType\PartNumInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartNumInfo[] = $item;
        return $this;
    }
    /**
     * Get PartType value
     * @return string|null
     */
    public function getPartType()
    {
        return $this->PartType;
    }
    /**
     * Set PartType value
     * @param string $partType
     * @return \StructType\QuotedPartType
     */
    public function setPartType($partType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partType) && strlen($partType) > 80) || (is_array($partType) && count($partType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($partType) ? strlen($partType) : count($partType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partType) && strlen($partType) < 1) || (is_array($partType) && count($partType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($partType) && !preg_match('/[\\p{IsBasicLatin}]*/', $partType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($partType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partType) && !is_string($partType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partType)), __LINE__);
        }
        $this->PartType = $partType;
        return $this;
    }
    /**
     * Get PartDesc value
     * @return string|null
     */
    public function getPartDesc()
    {
        return $this->PartDesc;
    }
    /**
     * Set PartDesc value
     * @param string $partDesc
     * @return \StructType\QuotedPartType
     */
    public function setPartDesc($partDesc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partDesc) && strlen($partDesc) > 255) || (is_array($partDesc) && count($partDesc) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($partDesc) ? strlen($partDesc) : count($partDesc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partDesc) && strlen($partDesc) < 1) || (is_array($partDesc) && count($partDesc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partDesc) && !is_string($partDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partDesc)), __LINE__);
        }
        $this->PartDesc = $partDesc;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return \StructType\PriceInfoType|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param \StructType\PriceInfoType $priceInfo
     * @return \StructType\QuotedPartType
     */
    public function setPriceInfo(\StructType\PriceInfoType $priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get AftermarketInfo value
     * @return \StructType\AftermarketInfoType|null
     */
    public function getAftermarketInfo()
    {
        return $this->AftermarketInfo;
    }
    /**
     * Set AftermarketInfo value
     * @param \StructType\AftermarketInfoType $aftermarketInfo
     * @return \StructType\QuotedPartType
     */
    public function setAftermarketInfo(\StructType\AftermarketInfoType $aftermarketInfo = null)
    {
        $this->AftermarketInfo = $aftermarketInfo;
        return $this;
    }
    /**
     * Get RecycleInfo value
     * @return \StructType\RecycleInfoType|null
     */
    public function getRecycleInfo()
    {
        return $this->RecycleInfo;
    }
    /**
     * Set RecycleInfo value
     * @param \StructType\RecycleInfoType $recycleInfo
     * @return \StructType\QuotedPartType
     */
    public function setRecycleInfo(\StructType\RecycleInfoType $recycleInfo = null)
    {
        $this->RecycleInfo = $recycleInfo;
        return $this;
    }
    /**
     * Get QuoteInfo value
     * @return \StructType\QuoteInfoType|null
     */
    public function getQuoteInfo()
    {
        return $this->QuoteInfo;
    }
    /**
     * Set QuoteInfo value
     * @param \StructType\QuoteInfoType $quoteInfo
     * @return \StructType\QuotedPartType
     */
    public function setQuoteInfo(\StructType\QuoteInfoType $quoteInfo = null)
    {
        $this->QuoteInfo = $quoteInfo;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\AvailabilityType|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \StructType\AvailabilityType $availability
     * @return \StructType\QuotedPartType
     */
    public function setAvailability(\StructType\AvailabilityType $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get OrderToReceiptDays value
     * @return int|null
     */
    public function getOrderToReceiptDays()
    {
        return $this->OrderToReceiptDays;
    }
    /**
     * Set OrderToReceiptDays value
     * @param int $orderToReceiptDays
     * @return \StructType\QuotedPartType
     */
    public function setOrderToReceiptDays($orderToReceiptDays = null)
    {
        // validation for constraint: maxInclusive
        if ($orderToReceiptDays > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9, "%s" given', $orderToReceiptDays), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($orderToReceiptDays < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $orderToReceiptDays), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($orderToReceiptDays) && !is_numeric($orderToReceiptDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderToReceiptDays)), __LINE__);
        }
        $this->OrderToReceiptDays = $orderToReceiptDays;
        return $this;
    }
    /**
     * Get LineNoteInfo value
     * @return \StructType\LineNoteInfoType|null
     */
    public function getLineNoteInfo()
    {
        return $this->LineNoteInfo;
    }
    /**
     * Set LineNoteInfo value
     * @param \StructType\LineNoteInfoType $lineNoteInfo
     * @return \StructType\QuotedPartType
     */
    public function setLineNoteInfo(\StructType\LineNoteInfoType $lineNoteInfo = null)
    {
        $this->LineNoteInfo = $lineNoteInfo;
        return $this;
    }
    /**
     * Get FileAttachment value
     * @return \StructType\FileAttachmentType|null
     */
    public function getFileAttachment()
    {
        return $this->FileAttachment;
    }
    /**
     * Set FileAttachment value
     * @param \StructType\FileAttachmentType $fileAttachment
     * @return \StructType\QuotedPartType
     */
    public function setFileAttachment(\StructType\FileAttachmentType $fileAttachment = null)
    {
        $this->FileAttachment = $fileAttachment;
        return $this;
    }
    /**
     * Get PartsWarrantyInfo value
     * @return \StructType\WarrantyInfoType[]|null
     */
    public function getPartsWarrantyInfo()
    {
        return $this->PartsWarrantyInfo;
    }
    /**
     * Set PartsWarrantyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\WarrantyInfoType[] $partsWarrantyInfo
     * @return \StructType\QuotedPartType
     */
    public function setPartsWarrantyInfo(array $partsWarrantyInfo = array())
    {
        foreach ($partsWarrantyInfo as $quotedPartTypePartsWarrantyInfoItem) {
            // validation for constraint: itemType
            if (!$quotedPartTypePartsWarrantyInfoItem instanceof \StructType\WarrantyInfoType) {
                throw new \InvalidArgumentException(sprintf('The PartsWarrantyInfo property can only contain items of \StructType\WarrantyInfoType, "%s" given', is_object($quotedPartTypePartsWarrantyInfoItem) ? get_class($quotedPartTypePartsWarrantyInfoItem) : gettype($quotedPartTypePartsWarrantyInfoItem)), __LINE__);
            }
        }
        $this->PartsWarrantyInfo = $partsWarrantyInfo;
        return $this;
    }
    /**
     * Add item to PartsWarrantyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\WarrantyInfoType $item
     * @return \StructType\QuotedPartType
     */
    public function addToPartsWarrantyInfo(\StructType\WarrantyInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarrantyInfoType) {
            throw new \InvalidArgumentException(sprintf('The PartsWarrantyInfo property can only contain items of \StructType\WarrantyInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartsWarrantyInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotedPartType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
