<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcurementRefInfoType StructType
 * @subpackage Structs
 */
class ProcurementRefInfoType extends AbstractStructBase
{
    /**
     * The RefNum
     * Meta informations extracted from the WSDL
     * - maxLength: 30
     * - minLength: 1 | 1
     * @var string
     */
    public $RefNum;
    /**
     * The ProcurementDocType
     * Meta informations extracted from the WSDL
     * - documentation: [Broker Request for Quote] : [This is a RFQ from a Broker to a Supplier] [Credit Memo] : [Credit Notification] [Hold] : [Request for Hold] [Hold Information Sent] : [Hold Information Sent] [Invoice] : [Invoice] [Location] :
     * [Obsolete. Correct usage is not to use this code.] [Other] : [Other] [Purchase Order] : [Purchase Order] [Purchase Order Confirmation] : [Purchase Order Confirmation] [Quote] : [Quote Provided] [Request for Quote] : [Request for Quote] [Return] :
     * [Return] [Return Authorization Number Sent] : [Return Merchandise Authorization Number Sent] [Return Authorization Request] : [Return Merchandise Authorization Request] [Shipping Change Cancel Notice] : [Shipping Change Cancel Notice] [Shipping
     * Notice] : [Shipping Notice]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $ProcurementDocType;
    /**
     * Constructor method for ProcurementRefInfoType
     * @uses ProcurementRefInfoType::setRefNum()
     * @uses ProcurementRefInfoType::setProcurementDocType()
     * @param string $refNum
     * @param string $procurementDocType
     */
    public function __construct($refNum = null, $procurementDocType = null)
    {
        $this
            ->setRefNum($refNum)
            ->setProcurementDocType($procurementDocType);
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \StructType\ProcurementRefInfoType
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($refNum) && strlen($refNum) > 30) || (is_array($refNum) && count($refNum) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($refNum) ? strlen($refNum) : count($refNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($refNum) && strlen($refNum) < 1) || (is_array($refNum) && count($refNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get ProcurementDocType value
     * @return string|null
     */
    public function getProcurementDocType()
    {
        return $this->ProcurementDocType;
    }
    /**
     * Set ProcurementDocType value
     * @param string $procurementDocType
     * @return \StructType\ProcurementRefInfoType
     */
    public function setProcurementDocType($procurementDocType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($procurementDocType) && strlen($procurementDocType) > 80) || (is_array($procurementDocType) && count($procurementDocType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($procurementDocType) ? strlen($procurementDocType) : count($procurementDocType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($procurementDocType) && strlen($procurementDocType) < 1) || (is_array($procurementDocType) && count($procurementDocType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($procurementDocType) && !preg_match('/[\\p{IsBasicLatin}]*/', $procurementDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($procurementDocType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($procurementDocType) && !is_string($procurementDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($procurementDocType)), __LINE__);
        }
        $this->ProcurementDocType = $procurementDocType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcurementRefInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
