<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcurementNotificationStsRq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Procurement notification status request
 * @subpackage Structs
 */
class ProcurementNotificationStsRq extends MessageHeaderType
{
    /**
     * The SvcProviderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - maxLength: 36
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $SvcProviderName;
    /**
     * The DocumentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\DocumentInfoType
     */
    public $DocumentInfo;
    /**
     * The ProcurementFolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\ProcurementFolderType
     */
    public $ProcurementFolder;
    /**
     * Constructor method for ProcurementNotificationStsRq
     * @uses ProcurementNotificationStsRq::setSvcProviderName()
     * @uses ProcurementNotificationStsRq::setDocumentInfo()
     * @uses ProcurementNotificationStsRq::setProcurementFolder()
     * @param string $svcProviderName
     * @param \StructType\DocumentInfoType $documentInfo
     * @param \StructType\ProcurementFolderType $procurementFolder
     */
    public function __construct($svcProviderName = null, \StructType\DocumentInfoType $documentInfo = null, \StructType\ProcurementFolderType $procurementFolder = null)
    {
        $this
            ->setSvcProviderName($svcProviderName)
            ->setDocumentInfo($documentInfo)
            ->setProcurementFolder($procurementFolder);
    }
    /**
     * Get SvcProviderName value
     * @return string
     */
    public function getSvcProviderName()
    {
        return $this->SvcProviderName;
    }
    /**
     * Set SvcProviderName value
     * @param string $svcProviderName
     * @return \StructType\ProcurementNotificationStsRq
     */
    public function setSvcProviderName($svcProviderName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($svcProviderName) && strlen($svcProviderName) > 36) || (is_array($svcProviderName) && count($svcProviderName) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($svcProviderName) ? strlen($svcProviderName) : count($svcProviderName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($svcProviderName) && strlen($svcProviderName) < 1) || (is_array($svcProviderName) && count($svcProviderName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($svcProviderName) && !preg_match('/[\\p{IsBasicLatin}]*/', $svcProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($svcProviderName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($svcProviderName) && !is_string($svcProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($svcProviderName)), __LINE__);
        }
        $this->SvcProviderName = $svcProviderName;
        return $this;
    }
    /**
     * Get DocumentInfo value
     * @return \StructType\DocumentInfoType
     */
    public function getDocumentInfo()
    {
        return $this->DocumentInfo;
    }
    /**
     * Set DocumentInfo value
     * @param \StructType\DocumentInfoType $documentInfo
     * @return \StructType\ProcurementNotificationStsRq
     */
    public function setDocumentInfo(\StructType\DocumentInfoType $documentInfo = null)
    {
        $this->DocumentInfo = $documentInfo;
        return $this;
    }
    /**
     * Get ProcurementFolder value
     * @return \StructType\ProcurementFolderType
     */
    public function getProcurementFolder()
    {
        return $this->ProcurementFolder;
    }
    /**
     * Set ProcurementFolder value
     * @param \StructType\ProcurementFolderType $procurementFolder
     * @return \StructType\ProcurementNotificationStsRq
     */
    public function setProcurementFolder(\StructType\ProcurementFolderType $procurementFolder = null)
    {
        $this->ProcurementFolder = $procurementFolder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcurementNotificationStsRq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
