<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The OrgInfo
     * @var \StructType\OrgInfoType
     */
    public $OrgInfo;
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setOrgInfo()
     * @uses PartyType::setContactInfo()
     * @param \StructType\OrgInfoType $orgInfo
     * @param \StructType\ContactInfoType[] $contactInfo
     */
    public function __construct(\StructType\OrgInfoType $orgInfo = null, array $contactInfo = array())
    {
        $this
            ->setOrgInfo($orgInfo)
            ->setContactInfo($contactInfo);
    }
    /**
     * Get OrgInfo value
     * @return \StructType\OrgInfoType|null
     */
    public function getOrgInfo()
    {
        return $this->OrgInfo;
    }
    /**
     * Set OrgInfo value
     * @param \StructType\OrgInfoType $orgInfo
     * @return \StructType\PartyType
     */
    public function setOrgInfo(\StructType\OrgInfoType $orgInfo = null)
    {
        $this->OrgInfo = $orgInfo;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\PartyType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        foreach ($contactInfo as $partyTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$partyTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of \StructType\ContactInfoType, "%s" given', is_object($partyTypeContactInfoItem) ? get_class($partyTypeContactInfoItem) : gettype($partyTypeContactInfoItem)), __LINE__);
            }
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\PartyType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of \StructType\ContactInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
