<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartItemRequestInfoType StructType
 * @subpackage Structs
 */
class PartItemRequestInfoType extends AbstractStructBase
{
    /**
     * The BMSObject
     * @var \StructType\BMSObjectType
     */
    public $BMSObject;
    /**
     * The UniqueSequenceNum
     * Meta informations extracted from the WSDL
     * - maxInclusive: 9999
     * - minInclusive: 1
     * @var int
     */
    public $UniqueSequenceNum;
    /**
     * The PartNumInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PartNumInfoType[]
     */
    public $PartNumInfo;
    /**
     * The PartType
     * Meta informations extracted from the WSDL
     * - documentation: [AD] : [Adhesive Kit] [GA] : [Gasket] [GF] : [Glass Frame] [GL] : [Glass] [HW] : [Hardware (Clips, screws, etc)] [IM] : [Installation Materials] [LO] : [Labor Only] [MO] : [Mouldings] [OT] : [Other] [PAA] : [Parts - Aftermarket]
     * [PAC] : [Parts - Rechromed] [PAD] : [Parts - Reconditioned] [PAE] : [Parts - Existing] [PAG] : [Parts � Glass] [PAGN] : [Parts - New Non-OEM Glass] [PAL] : [Parts - Recycled] [PAM] : [Parts - Remanufactured] [PAN] : [Parts - New OEM] [PAND] :
     * [Parts - New OEM discounted] [PAO] : [Parts - Other] [PAP] : [Parts - New, partial] [PAR] : [Parts - Re-cored] [PC] : [Parts - Core only] [RP] : [Repair] [TI] : [Tinting] [WE] : [Weatherstrip]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $PartType;
    /**
     * The PartDesc
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * - minLength: 1 | 1
     * @var string
     */
    public $PartDesc;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxInclusive: 9999999999.99
     * - minInclusive: 0
     * - totalDigits: 15
     * @var float
     */
    public $Quantity;
    /**
     * The PriceInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfoType
     */
    public $PriceInfo;
    /**
     * Constructor method for PartItemRequestInfoType
     * @uses PartItemRequestInfoType::setBMSObject()
     * @uses PartItemRequestInfoType::setUniqueSequenceNum()
     * @uses PartItemRequestInfoType::setPartNumInfo()
     * @uses PartItemRequestInfoType::setPartType()
     * @uses PartItemRequestInfoType::setPartDesc()
     * @uses PartItemRequestInfoType::setQuantity()
     * @uses PartItemRequestInfoType::setPriceInfo()
     * @param \StructType\BMSObjectType $bMSObject
     * @param int $uniqueSequenceNum
     * @param \StructType\PartNumInfoType[] $partNumInfo
     * @param string $partType
     * @param string $partDesc
     * @param float $quantity
     * @param \StructType\PriceInfoType $priceInfo
     */
    public function __construct(\StructType\BMSObjectType $bMSObject = null, $uniqueSequenceNum = null, array $partNumInfo = array(), $partType = null, $partDesc = null, $quantity = null, \StructType\PriceInfoType $priceInfo = null)
    {
        $this
            ->setBMSObject($bMSObject)
            ->setUniqueSequenceNum($uniqueSequenceNum)
            ->setPartNumInfo($partNumInfo)
            ->setPartType($partType)
            ->setPartDesc($partDesc)
            ->setQuantity($quantity)
            ->setPriceInfo($priceInfo);
    }
    /**
     * Get BMSObject value
     * @return \StructType\BMSObjectType|null
     */
    public function getBMSObject()
    {
        return $this->BMSObject;
    }
    /**
     * Set BMSObject value
     * @param \StructType\BMSObjectType $bMSObject
     * @return \StructType\PartItemRequestInfoType
     */
    public function setBMSObject(\StructType\BMSObjectType $bMSObject = null)
    {
        $this->BMSObject = $bMSObject;
        return $this;
    }
    /**
     * Get UniqueSequenceNum value
     * @return int|null
     */
    public function getUniqueSequenceNum()
    {
        return $this->UniqueSequenceNum;
    }
    /**
     * Set UniqueSequenceNum value
     * @param int $uniqueSequenceNum
     * @return \StructType\PartItemRequestInfoType
     */
    public function setUniqueSequenceNum($uniqueSequenceNum = null)
    {
        // validation for constraint: maxInclusive
        if ($uniqueSequenceNum > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999, "%s" given', $uniqueSequenceNum), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($uniqueSequenceNum < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $uniqueSequenceNum), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($uniqueSequenceNum) && !is_numeric($uniqueSequenceNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueSequenceNum)), __LINE__);
        }
        $this->UniqueSequenceNum = $uniqueSequenceNum;
        return $this;
    }
    /**
     * Get PartNumInfo value
     * @return \StructType\PartNumInfoType[]|null
     */
    public function getPartNumInfo()
    {
        return $this->PartNumInfo;
    }
    /**
     * Set PartNumInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PartNumInfoType[] $partNumInfo
     * @return \StructType\PartItemRequestInfoType
     */
    public function setPartNumInfo(array $partNumInfo = array())
    {
        foreach ($partNumInfo as $partItemRequestInfoTypePartNumInfoItem) {
            // validation for constraint: itemType
            if (!$partItemRequestInfoTypePartNumInfoItem instanceof \StructType\PartNumInfoType) {
                throw new \InvalidArgumentException(sprintf('The PartNumInfo property can only contain items of \StructType\PartNumInfoType, "%s" given', is_object($partItemRequestInfoTypePartNumInfoItem) ? get_class($partItemRequestInfoTypePartNumInfoItem) : gettype($partItemRequestInfoTypePartNumInfoItem)), __LINE__);
            }
        }
        $this->PartNumInfo = $partNumInfo;
        return $this;
    }
    /**
     * Add item to PartNumInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PartNumInfoType $item
     * @return \StructType\PartItemRequestInfoType
     */
    public function addToPartNumInfo(\StructType\PartNumInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartNumInfoType) {
            throw new \InvalidArgumentException(sprintf('The PartNumInfo property can only contain items of \StructType\PartNumInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartNumInfo[] = $item;
        return $this;
    }
    /**
     * Get PartType value
     * @return string|null
     */
    public function getPartType()
    {
        return $this->PartType;
    }
    /**
     * Set PartType value
     * @param string $partType
     * @return \StructType\PartItemRequestInfoType
     */
    public function setPartType($partType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partType) && strlen($partType) > 80) || (is_array($partType) && count($partType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($partType) ? strlen($partType) : count($partType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partType) && strlen($partType) < 1) || (is_array($partType) && count($partType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($partType) && !preg_match('/[\\p{IsBasicLatin}]*/', $partType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($partType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partType) && !is_string($partType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partType)), __LINE__);
        }
        $this->PartType = $partType;
        return $this;
    }
    /**
     * Get PartDesc value
     * @return string|null
     */
    public function getPartDesc()
    {
        return $this->PartDesc;
    }
    /**
     * Set PartDesc value
     * @param string $partDesc
     * @return \StructType\PartItemRequestInfoType
     */
    public function setPartDesc($partDesc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partDesc) && strlen($partDesc) > 255) || (is_array($partDesc) && count($partDesc) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($partDesc) ? strlen($partDesc) : count($partDesc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($partDesc) && strlen($partDesc) < 1) || (is_array($partDesc) && count($partDesc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partDesc) && !is_string($partDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partDesc)), __LINE__);
        }
        $this->PartDesc = $partDesc;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\PartItemRequestInfoType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: maxInclusive
        if ($quantity > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $quantity), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $quantity), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($quantity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $quantity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($quantity, strpos($quantity, '.')))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return \StructType\PriceInfoType|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param \StructType\PriceInfoType $priceInfo
     * @return \StructType\PartItemRequestInfoType
     */
    public function setPriceInfo(\StructType\PriceInfoType $priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartItemRequestInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
