<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInfoType StructType
 * @subpackage Structs
 */
class DocumentInfoType extends AbstractStructBase
{
    /**
     * The BMSVer
     * Meta informations extracted from the WSDL
     * - documentation: [1.0] : [Version approved 7/23/2003] [1.1.4] : [Version approved 10/30/2003] [1.1.5] : [Version approved 12/18/2003] [1.1.6] : [Version approved 1/8/2004] [1.1.8] : [Version approved 2/12/2004] [1.1.9] : [Version approved 3/25/2004]
     * [1.2.0] : [Version approved 4/22/2004] [1.3.4] : [Version approved 8/03/2004] [1.3.5] : [Version approved 9/30/2004] [1.3.6] : [Version approved 11/2/2004] [1.3.7] : [Version approved 1/11/2005] [2.0.0] : [Version approved 4/28/2005] [2.1.0] :
     * [Version approved 8/18/2005] [2.2.0] : [Version approved 9/15/2005] [2.5.0] : [Version approved 02/23/2006] [2.6.0] : [Version approved�10/19/2006] [2.7.0] : [Version approved 12/28/2006] [2.8.0] : [Version approved 1/11/2007] [2.9.0] : [Version
     * approved 1/25/2007] [2.9.1] : [Version approved 3/15/2007] [2.10.0] : [Version approved 9/13/2007] [3.0.0] : [Version Approved 10/18/2007] [3.1.1] : [Version Approved 01/03/2008] [3.1.2] : [Version Approved 01/17/2008] [3.1.9] : [Version Approved
     * 05/15/2008] [3.2.0] : [Version Approved 06/26/2008] [3.2.1] : [Version Approved 09/25/2008] [3.3.0] : [Version Approved 03/05/2009] [3.3.5] : [Version Approved 03/05/2009] [4.0.0] : [Version Approved 10/29/2009] [4.1.0] : [Version Approved
     * 05/02/2010] [4.2.0] : [Version Approved 10/08/2010] [4.3.0] : [Version Approved 04/27/2011] [4.4.0] : [Version Approved 12/21/2011] [4.5.0] : [Version Approved 04/30/2012] [4.6.0] : [Version Approved 12/19/2012]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $BMSVer;
    /**
     * The DocumentType
     * Meta informations extracted from the WSDL
     * - documentation: [A] : [Vehicle Damage Assignment] [AO] : [Attachment(s) Only] [C] : [Repair Order Close] [CI] : [Claim Information Add] [CR] : [Customer Survey Results] [CS] : [Customer Survey List] [CSR] : [Claim Save Request] [D] : [Salvage
     * Disposition] [E] : [Vehicle Damage Estimate] [F] : [Final Bill] [GA] : [Glass Assignment] [GI] : [Glass Invoice] [GR] : [Glass Remittance] [GS] : [Glass Statement] [P] : [Part Price Change] [PA] : [Property Assignment] [PDE] : [Property Damage
     * Estimate] [PGI] : [Property Glass Invoice] [PGR] : [Property Glass Remittance] [PGS] : [Property Glass Statement] [PMP] : [Parts and Material Procurement] [PR] : [Parts and Material Procurement Remittance] [PS] : [Parts and Material Procurement
     * Statement] [R] : [Rental Assignment] [RA] : [Rental Authorization] [RI] : [Rental Invoice] [RL] : [Rental Location] [RO] : [Repair Order] [RR] : [Rental Remittance] [S] : [Salvage Assignment] [SA] : [Subrogation Assignment and/or Demand] [SC] :
     * [Survey Report] [SCA] : [Salvage Cancellation] [SCH] : [Salvage Change] [SI] : [Subrogation Inquiry] [SR] : [Salvage Reassignment] [SS] : [Salvage Status] [SSM] : [Subrogation Status Message] [ST] : [Status Message] [TI] : [Towing Invoice] [TM] :
     * [Title Messages] [TR] : [Towing Remittance] [U] : [Administrative Update] [VA] : [Vehicle Evaluation Assignment] [ValCanRq] : [Valuation Cancellation Request] [ValCanCfm] : [Confirmation of Valuation Cancellation] [ValInfoRq] : [Valuation Information
     * Request] [ValInqRq] : [Valuation Inquiry Request] [ValRpt] : [Valuation Report] [ValRq] : [Valuation Request] [ValSts] : [Valuation Status] [VE] : [Vehicle Evaluation] [VI] : [Vehicle Inspection Report] [VRI] : [Vehicle Repair Invoice] [VRR] :
     * [Vehicle Repair Remittance] [Z] : [Partner Defined]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $DocumentType;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * Constructor method for DocumentInfoType
     * @uses DocumentInfoType::setBMSVer()
     * @uses DocumentInfoType::setDocumentType()
     * @uses DocumentInfoType::setCreateDateTime()
     * @param string $bMSVer
     * @param string $documentType
     * @param string $createDateTime
     */
    public function __construct($bMSVer = null, $documentType = null, $createDateTime = null)
    {
        $this
            ->setBMSVer($bMSVer)
            ->setDocumentType($documentType)
            ->setCreateDateTime($createDateTime);
    }
    /**
     * Get BMSVer value
     * @return string|null
     */
    public function getBMSVer()
    {
        return $this->BMSVer;
    }
    /**
     * Set BMSVer value
     * @param string $bMSVer
     * @return \StructType\DocumentInfoType
     */
    public function setBMSVer($bMSVer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bMSVer) && strlen($bMSVer) > 80) || (is_array($bMSVer) && count($bMSVer) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($bMSVer) ? strlen($bMSVer) : count($bMSVer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bMSVer) && strlen($bMSVer) < 1) || (is_array($bMSVer) && count($bMSVer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bMSVer) && !preg_match('/[\\p{IsBasicLatin}]*/', $bMSVer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($bMSVer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bMSVer) && !is_string($bMSVer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bMSVer)), __LINE__);
        }
        $this->BMSVer = $bMSVer;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \StructType\DocumentInfoType
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentType) && strlen($documentType) > 80) || (is_array($documentType) && count($documentType) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($documentType) ? strlen($documentType) : count($documentType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentType) && strlen($documentType) < 1) || (is_array($documentType) && count($documentType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($documentType) && !preg_match('/[\\p{IsBasicLatin}]*/', $documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($documentType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\DocumentInfoType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
