<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComplicationType StructType
 * @subpackage Structs
 */
class ComplicationType extends AbstractStructBase
{
    /**
     * The BMSObject
     * @var \StructType\BMSObjectType
     */
    public $BMSObject;
    /**
     * The SupplierResponseCode
     * Meta informations extracted from the WSDL
     * - documentation: [Alternative] : [Alternative] [AsRequested] : [As Requested] [Complication] : [Complication] [Related] : [Related]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The SupplierRefLineNum
     * Meta informations extracted from the WSDL
     * - maxInclusive: 9999999999
     * - minInclusive: 0
     * @var int
     */
    public $SupplierRefLineNum;
    /**
     * The ProcessingInstructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - minLength: 1
     * @var string
     */
    public $ProcessingInstructions;
    /**
     * Constructor method for ComplicationType
     * @uses ComplicationType::setBMSObject()
     * @uses ComplicationType::setSupplierResponseCode()
     * @uses ComplicationType::setSupplierRefLineNum()
     * @uses ComplicationType::setProcessingInstructions()
     * @param \StructType\BMSObjectType $bMSObject
     * @param string $supplierResponseCode
     * @param int $supplierRefLineNum
     * @param string $processingInstructions
     */
    public function __construct(\StructType\BMSObjectType $bMSObject = null, $supplierResponseCode = null, $supplierRefLineNum = null, $processingInstructions = null)
    {
        $this
            ->setBMSObject($bMSObject)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setSupplierRefLineNum($supplierRefLineNum)
            ->setProcessingInstructions($processingInstructions);
    }
    /**
     * Get BMSObject value
     * @return \StructType\BMSObjectType|null
     */
    public function getBMSObject()
    {
        return $this->BMSObject;
    }
    /**
     * Set BMSObject value
     * @param \StructType\BMSObjectType $bMSObject
     * @return \StructType\ComplicationType
     */
    public function setBMSObject(\StructType\BMSObjectType $bMSObject = null)
    {
        $this->BMSObject = $bMSObject;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \StructType\ComplicationType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($supplierResponseCode) && strlen($supplierResponseCode) > 80) || (is_array($supplierResponseCode) && count($supplierResponseCode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($supplierResponseCode) ? strlen($supplierResponseCode) : count($supplierResponseCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($supplierResponseCode) && strlen($supplierResponseCode) < 1) || (is_array($supplierResponseCode) && count($supplierResponseCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($supplierResponseCode) && !preg_match('/[\\p{IsBasicLatin}]*/', $supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($supplierResponseCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get SupplierRefLineNum value
     * @return int|null
     */
    public function getSupplierRefLineNum()
    {
        return $this->SupplierRefLineNum;
    }
    /**
     * Set SupplierRefLineNum value
     * @param int $supplierRefLineNum
     * @return \StructType\ComplicationType
     */
    public function setSupplierRefLineNum($supplierRefLineNum = null)
    {
        // validation for constraint: maxInclusive
        if ($supplierRefLineNum > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $supplierRefLineNum), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($supplierRefLineNum < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $supplierRefLineNum), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($supplierRefLineNum) && !is_numeric($supplierRefLineNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierRefLineNum)), __LINE__);
        }
        $this->SupplierRefLineNum = $supplierRefLineNum;
        return $this;
    }
    /**
     * Get ProcessingInstructions value
     * @return string|null
     */
    public function getProcessingInstructions()
    {
        return $this->ProcessingInstructions;
    }
    /**
     * Set ProcessingInstructions value
     * @param string $processingInstructions
     * @return \StructType\ComplicationType
     */
    public function setProcessingInstructions($processingInstructions = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($processingInstructions) && strlen($processingInstructions) < 1) || (is_array($processingInstructions) && count($processingInstructions) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($processingInstructions) && !is_string($processingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processingInstructions)), __LINE__);
        }
        $this->ProcessingInstructions = $processingInstructions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComplicationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
