<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComplicationListType StructType
 * @subpackage Structs
 */
class ComplicationListType extends AbstractStructBase
{
    /**
     * The Complication
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ComplicationType[]
     */
    public $Complication;
    /**
     * Constructor method for ComplicationListType
     * @uses ComplicationListType::setComplication()
     * @param \StructType\ComplicationType[] $complication
     */
    public function __construct(array $complication = array())
    {
        $this
            ->setComplication($complication);
    }
    /**
     * Get Complication value
     * @return \StructType\ComplicationType[]|null
     */
    public function getComplication()
    {
        return $this->Complication;
    }
    /**
     * Set Complication value
     * @throws \InvalidArgumentException
     * @param \StructType\ComplicationType[] $complication
     * @return \StructType\ComplicationListType
     */
    public function setComplication(array $complication = array())
    {
        foreach ($complication as $complicationListTypeComplicationItem) {
            // validation for constraint: itemType
            if (!$complicationListTypeComplicationItem instanceof \StructType\ComplicationType) {
                throw new \InvalidArgumentException(sprintf('The Complication property can only contain items of \StructType\ComplicationType, "%s" given', is_object($complicationListTypeComplicationItem) ? get_class($complicationListTypeComplicationItem) : gettype($complicationListTypeComplicationItem)), __LINE__);
            }
        }
        $this->Complication = $complication;
        return $this;
    }
    /**
     * Add item to Complication value
     * @throws \InvalidArgumentException
     * @param \StructType\ComplicationType $item
     * @return \StructType\ComplicationListType
     */
    public function addToComplication(\StructType\ComplicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ComplicationType) {
            throw new \InvalidArgumentException(sprintf('The Complication property can only contain items of \StructType\ComplicationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Complication[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComplicationListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
